% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afp.R
\name{afp}
\alias{afp}
\title{Calculate aerosol formation potential}
\usage{
afp(
  df,
  inunit = "ppbv",
  t = 25,
  p = 101.325,
  stcd = FALSE,
  sortd = TRUE,
  chn = FALSE
)
}
\arguments{
\item{df}{dataframe contains time series.}

\item{inunit}{input's unit for VOC concentration. A character vector from these options: "ugm" or "ppbv". 
"ugm" means ug/m3. "ppbv" means part per billion volumn. The default vaule is "ppbv".}

\item{t}{Temperature, in Degrees Celsius, used to convert data in 
micrograms per cubic meter to standard conditions 
(25 Degrees Celsius, 101.325 kPa). By default, t equals to 25 Degrees Celsius.}

\item{p}{Pressure, in kPa, used to convert data in micrograms per cubic meter 
to standard conditions (25 Degrees Celsius, 101.325 kPa). 
By default, p equals to 101.325 kPa.}

\item{stcd}{logical. Does it output results in standard conditions? The default vaule is FALSE.}

\item{sortd}{logical value. It determines whether the VOC species
are sorted or not. By default, sortd has value "TRUE".
If TRUE, VOC species in time series will be arranged according to VOC group,
 relative molecular weight, and SOAY value.}

\item{chn}{logical. Dose colnames present as Chinese? The default vaule is FALSE.}
}
\value{
a list contains 5 tables:
SOAY_Result: matched SOAY value result;
AFP_Result: AFP time series of VOC by species;
AFP_Result_mean: the average value and proportion of AFP of VOC by species (sorted from large to small);
AFP_Result_group: AFP time series of VOC classified by groups;
AFP_Result_group_mean: the average value and proportion of AFP of VOC according to major groups (sorted from large to small).
}
\description{
Calculate Aerosol Formation Potential (AFP) of VOC time series. Unit of AFP is ug/m3.
Note: for Chinese VOC name, please also use English punctuation.
}
\details{
The CAS number is matched for each VOC speices (from column name), and the
average SOA yield (SOAY) is matched through the CAS number and used for time series calculation. \cr
The average SOAY comes from "W. Wu, B. Zhao, S. Wang, J. Hao, Ozone 
and secondary organic aerosol formation potential from anthropogenic volatile 
organic compounds emissions in China. J Environ Sci. 53, 224–237 (2017)".
Note: If input VOC species contain M,P-xylene, it will be automatically divided into m-xylene and P-xylene evenly.
}
