% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{fct_count}
\alias{fct_count}
\title{Count entries in a factor}
\usage{
fct_count(f, sort = FALSE)
}
\arguments{
\item{f}{A factor}

\item{sort}{If \code{TRUE}, sort the result so that most common values
float to the top.}
}
\value{
A tibble with columns \code{f} and \code{n}
}
\description{
Count entries in a factor
}
\examples{
f <- factor(sample(letters)[rpois(1000, 10)])
table(f)
fct_count(f)
fct_count(f, sort = TRUE)
}

