% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relabel.R
\name{fct_relabel}
\alias{fct_relabel}
\title{Automatically relabel factor levels, collapse as necessary}
\usage{
fct_relabel(.f, .fun, ...)
}
\arguments{
\item{.f}{A factor (or character vector).}

\item{.fun}{A function to be applied to each level. Must accept one
character argument and return a character vector of the same length as
its input.

You can also use \code{~} to create as shorthand (in the style of purrr).
\code{~ paste(., "x")} is equivalent to \code{function(.) paste(., "x")}}

\item{...}{Additional arguments to \code{fun}.}
}
\description{
Automatically relabel factor levels, collapse as necessary
}
\examples{
gss_cat$partyid \%>\% fct_count()
gss_cat$partyid \%>\%
  fct_relabel(~ gsub(",", ", ", .x)) \%>\%
  fct_count()

convert_income <- function(x) {
  regex <- "^(?:Lt |)[$]([0-9]+).*$"
  is_range <- grepl(regex, x)
  num_income <- as.numeric(gsub(regex, "\\\\1", x[is_range]))
  num_income <- trunc(num_income / 5000) * 5000
  x[is_range] <- paste0("Gt $", num_income)
  x
}
fct_count(gss_cat$rincome)
convert_income(levels(gss_cat$rincome))
rincome2 <- fct_relabel(gss_cat$rincome, convert_income)
fct_count(rincome2)
}
