% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributeCalculator.R
\name{calculateAttributes}
\alias{calculateAttributes}
\title{Calculates the attributes of the hydroclimate time series}
\usage{
calculateAttributes(climateData, attSel, startYr = NULL, endYr = NULL)
}
\arguments{
\item{climateData}{data.frame; daily climate data, the attributes of which are to be calculated. \code{climateData} should be a data.frame with columns named \emph{year} \emph{month} \emph{day} \emph{*variable_name1*} \emph{*variable_name2*}. 
Use \code{viewModels()} to view the valid variable names. Note that the first three columns of the data.frame contain the year, month, and day of the data. The columns have to be named as specified.
Please refer data provided with the package that may be loaded using \code{data(tankDat)} for an example of the expected format of \code{climateData}.}

\item{attSel}{a vector; specifying the names of the attributes to be calculated.}

\item{startYr}{a number (default \code{NULL}); to specify the starting year to subset \code{climateData} if required. 
If \code{NULL}, \code{startYr} is starting year in the input \code{climateData}.}

\item{endYr}{a number (default \code{NULL}); to specify the ending year to subset \code{climateData} if required. 
If \code{NULL}, \code{endYr} is last year in the input \code{climateData}.}
}
\value{
The function returns a vector of length equal to the number of selected attributes (\code{attSel}), named using the names of the attributes.
}
\description{
\code{calculateAttributes} calculates the specified attributes of the input daily hydroclimate time series.
}
\examples{
# view the names of available attributes
viewAttributes()
# load example climate data available in the package
data("tankDat")
attSel <- c("P_ann_tot_m", "P_ann_nWet_m", "P_ann_R10_m", "Temp_ann_rng_m", "Temp_ann_avg_m")
tank_obs_atts <- calculateAttributes(tank_obs, attSel = attSel)
}
\seealso{
\code{viewAttributes}, \code{viewAttributeDef}
}
