% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{generateScenarios}
\alias{generateScenarios}
\title{Produces time series of hydroclimatic variables for an exposure space.}
\usage{
generateScenarios(
  reference,
  expSpace,
  simLengthNyrs = NULL,
  numReplicates = 1,
  seedID = NULL,
  controlFile = NULL
)
}
\arguments{
\item{reference}{data.frame; contains reference daily climate data in a data frame with columns named \emph{year} \emph{month} \emph{day} \emph{*variable_name1*} \emph{*variable_name2*}. 
Use \code{viewModels()} to view the valid variable names. Note that the first three columns of the data.frame contain the year, month, and day of the reference. The columns have to be named as specified.
Please refer data provided with the package that may be loaded using \code{data(tankDat)} for an example of the expected format of \code{reference}.}

\item{expSpace}{a list; created using the function \code{createExpSpace}}

\item{simLengthNyrs}{a number; a scalar that specifies the length in years of each generated scenario. This argument is used only with stochastic generation.
If \code{NULL} (the default), the generated simulation will be as long as \code{reference}.}

\item{numReplicates}{a number; a scalar that specific the number of stochastic replicates to be generated. The default is 1.}

\item{seedID}{a number; a scalar that specifies the seed to be used for the first replicate. Subsequent replicates will use seeds incremented by one. 
If \code{seedID} is \code{NULL} (which is the default), the function will use a random seed for stochastic time series generation. 
The seed used will be specified in the output. This argument is intended for use in cases that aim to reproduce an existing simulation.}

\item{controlFile}{a string; to specify the model/optimisation options used for simulating time series data. The valid values are:
\itemize{
\item {\code{NULL}} {: the simulation uses the foreSIGHT default stochastic model settings.}
\item {\code{"scaling"}} {: the simulation uses simple scaling instead of a stochastic model.}
\item {\code{path to a JSON file}} {: the JSON file contains advanced options specify the stochastic model and optimisation inputs. 
                  These options can be used to change stochastic model types, overwrite default model parameter bounds, change default optimisation arguments, and set penalty attributes to be used in optimisation. 
                  Please refer to the function \code{writeControlFile} in order to create an \code{controlFile} JSON file.
                  }
                  }}
}
\value{
The function returns a list containing the time series data generated. The list can contain multiple replicates (named as \code{Rep1}, \code{Rep2} etc.) equal to the \code{numReplicates} function argument.
        Each replicate can contain multiple targets (named as \code{Target1}, \code{Target2} etc.) based on the specified exposure space (\code{expSpace}). The \code{expSpace} and \code{controlFile} are also returned as part of this output list.
}
\description{
\code{generateScenarios} produces time series of hydroclimatic variables using requested climate attributes that correspond to a target exposure space using a reference daily time series as an input.
}
\examples{
# Example 1: Stochastic simulation using foreSIGHT default settings
#----------------------------------------------------------------------
\dontrun{
# create an exposure space
attPerturb <- c("P_ann_tot_m", "P_ann_nWet_m", "P_ann_R10_m")
attHold <- c("P_Feb_tot_m", "P_SON_dyWet_m", "P_JJA_avgWSD_m", "P_MAM_tot_m", 
"P_DJF_avgDSD_m", "Temp_ann_rng_m", "Temp_ann_avg_m")
attPerturbType = "regGrid"
attPerturbSamp = c(2, 1, 1)
attPerturbMin = c(0.8, 1, 1)
attPerturbMax = c(1.1, 1, 1)
expSpace <- createExpSpace(attPerturb = attPerturb, 
                           attPerturbSamp = attPerturbSamp, 
                           attPerturbMin = attPerturbMin,
                           attPerturbMax = attPerturbMax,
                           attPerturbType = attPerturbType,
                           attHold = attHold,
                           attTargetsFile = NULL)
# load example data available in foreSIGHT
data(tankDat)
# perform stochastic simulation
simStochastic <- generateScenarios(reference = tank_obs,
                                   expSpace = expSpace,
                                   simLengthNyrs = 30)
                                   }
# Example 2: Simple scaling
#-----------------------------------------------------------------------
attPerturb<-c("P_ann_tot_m","Temp_ann_avg_m")
attPerturbType = "regGrid"
attPerturbSamp = c(2, 2)
attPerturbMin = c(0.8, -1)
attPerturbMax = c(1.1, 1)
expSpace <- createExpSpace(attPerturb = attPerturb,
                           attPerturbSamp = attPerturbSamp, 
                           attPerturbMin = attPerturbMin, 
                           attPerturbMax = attPerturbMax, 
                           attPerturbType = attPerturbType)
data(tankDat)
simScaling <- generateScenarios(reference = tank_obs,
                                expSpace = expSpace,
                                controlFile = "scaling")
                                
}
\seealso{
\code{createExpSpace}, \code{writeControlFile}, \code{viewModels}
}
