% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distKL.R
\name{distKL}
\alias{distKL}
\title{distKL: KL distribution obtained for specific relative contributor}
\usage{
distKL(ped, missing, relative, frequency, numsims = 100, cores = 1)
}
\arguments{
\item{ped}{Reference pedigree. It could be an input from read_fam() function or a pedigree built with pedtools. # nolint}

\item{missing}{Missing person}

\item{relative}{Selected relative.}

\item{frequency}{Allele frequency database.}

\item{numsims}{Number of simulated genotypes.}

\item{cores}{Enables parallelization.}
}
\value{
An object of class data.frame with KLs.
}
\description{
distKL: KL distribution obtained for specific relative contributor
}
\examples{
library(forrel)
x = linearPed(2)
x = setMarkers(x, locusAttributes = NorwegianFrequencies[1:2])
x = profileSim(x, N = 1, ids = 2)
distKL(ped = x, missing = 5, relative = 1, cores = 1,
frequency = NorwegianFrequencies[1:2], numsims = 3)
}
