% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_datasets.R
\docType{data}
\name{comp_bayes_lm_ex}
\alias{comp_bayes_lm_ex}
\title{Example bayesian competition model fit}
\format{
A list subclass containing the following elements:

\describe{
\item{prior_params}{Prior parameters supplied to \code{\link[=comp_bayes_lm]{comp_bayes_lm()}}}
\item{post_params}{Posterior parameters outputted by \code{\link[=comp_bayes_lm]{comp_bayes_lm()}}}
\item{terms}{The formula object used in model fitting}
}
}
\usage{
comp_bayes_lm_ex
}
\description{
This object contains an example fitted Bayesian competition
model outputted by \code{\link[=comp_bayes_lm]{comp_bayes_lm()}}.
}
\examples{
library(dplyr)
library(yardstick)

# Compare model predictions to observation
predictions <- focal_vs_comp_ex \%>\%
  mutate(growth_hat = predict(comp_bayes_lm_ex, focal_vs_comp_ex))

predictions \%>\%
  rmse(truth = growth, estimate = growth_hat) \%>\%
  pull(.estimate)

# Plot posterior parameters
comp_bayes_lm_ex \%>\%
  autoplot()
}
\seealso{
\code{\link[=comp_bayes_lm]{comp_bayes_lm()}}

Other example data objects: 
\code{\link{blocks_ex}},
\code{\link{census_1_ex}},
\code{\link{census_2008_bw}},
\code{\link{census_2014_bw}},
\code{\link{census_2_ex}},
\code{\link{focal_vs_comp_ex}},
\code{\link{growth_ex}},
\code{\link{growth_spatial_ex}},
\code{\link{growth_toy}},
\code{\link{species_bw}},
\code{\link{study_region_bw}},
\code{\link{study_region_ex}}
}
\concept{example data objects}
\keyword{datasets}
