% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestplot_helpers.R
\name{fpColors}
\alias{fpColors}
\title{A function for the color elements used in forestplot()}
\usage{
fpColors(
  all.elements,
  box = "black",
  lines = "gray",
  summary = "black",
  zero = "lightgray",
  text = "black",
  axes = "black",
  hrz_lines = "black",
  vrtcl_lines = "lightgray"
)
}
\arguments{
\item{all.elements}{A color for all the elements. If set to NULL then
it's set to the par("fg") color}

\item{box}{The color of the box indicating the estimate}

\item{lines}{The color of the confidence lines}

\item{summary}{The color of the summary}

\item{zero}{The color of the zero line}

\item{text}{The color of the text}

\item{axes}{The color of the x-axis at the bottom}

\item{hrz_lines}{The color of the horizontal lines}

\item{vrtcl_lines}{The color of the vertical lines}
}
\value{
A list with key elements
}
\description{
This function encapsulates all the colors that are used in the
\code{\link{forestplot}} function. As there are plenty of color
options this function gathers them all in one place.
}
\details{
Further customization of non-text elements can be performed with
\code{\link{fpShapesGp}} passed as \code{shapes_gp} parameter to
\code{\link{forestplot}}. The \code{fpColors} function is kept for
backwards compatibility.

If you have several values per row in a forestplot you can set
a color to a vector where the first value represents the first
line/box, second the second line/box etc. The vectors are only
valid for the \code{box} & \code{lines} options.

This function is a copy of the \code{\link[rmeta]{meta.colors}}
function in the \pkg{rmeta} package.
}
\examples{
ask <- par(ask = TRUE)

# An example of how the exponential works
test_data <- data.frame(
  coef = c(2.45, 0.43),
  low = c(1.5, 0.25),
  high = c(4, 0.75),
  boxsize = c(0.5, 0.5)
)
row_names <- cbind(
  c("Name", "Variable A", "Variable B"),
  c("HR", test_data$coef)
)
test_data <- rbind(rep(NA, 3), test_data)

forestplot(
  labeltext = row_names,
  test_data[, c("coef", "low", "high")],
  is.summary = c(TRUE, FALSE, FALSE),
  boxsize = test_data$boxsize,
  zero = 1,
  xlog = TRUE,
  col = fpColors(lines = "#990000", box = "#660000", zero = "darkblue"),
  new_page = TRUE
)

par(ask = ask)
}
\seealso{
Other forestplot functions: 
\code{\link{forestplot}()},
\code{\link{fpDrawNormalCI}()},
\code{\link{fpLegend}()},
\code{\link{fpShapesGp}()},
\code{\link{fp_add_lines}()},
\code{\link{fp_decorate_graph}()},
\code{\link{fp_insert_row}()},
\code{\link{fp_set_style}()},
\code{\link{fp_set_zebra_style}()}
}
\author{
Max Gordon, Thomas Lumley
}
\concept{forestplot functions}
