% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{make_row_df}
\alias{make_row_df}
\alias{make_row_df,MatrixPrintForm-method}
\title{Make row layout summary data frames for use during pagination}
\usage{
make_row_df(
  tt,
  colwidths = NULL,
  visible_only = TRUE,
  rownum = 0,
  indent = 0L,
  path = character(),
  incontent = FALSE,
  repr_ext = 0L,
  repr_inds = integer(),
  sibpos = NA_integer_,
  nsibs = NA_integer_,
  max_width = NULL,
  fontspec = font_spec(),
  col_gap = 3L,
  round_type = c("iec", "sas")
)

\S4method{make_row_df}{MatrixPrintForm}(
  tt,
  colwidths = NULL,
  visible_only = TRUE,
  rownum = 0,
  indent = 0L,
  path = character(),
  incontent = FALSE,
  repr_ext = 0L,
  repr_inds = integer(),
  sibpos = NA_integer_,
  nsibs = NA_integer_,
  max_width = NULL,
  fontspec = font_spec(),
  col_gap = mf_colgap(tt) \%||\% 3L,
  round_type = c("iec", "sas")
)
}
\arguments{
\item{tt}{(\code{ANY})\cr object representing the table-like object to be summarized.}

\item{colwidths}{(\code{numeric})\cr internal detail, do not set manually.}

\item{visible_only}{(\code{flag})\cr should only visible aspects of the table structure be reflected
in this summary. Defaults to \code{TRUE}. May not be supported by all methods.}

\item{rownum}{(\code{numeric(1)})\cr internal detail, do not set manually.}

\item{indent}{(\code{integer(1)})\cr internal detail, do not set manually.}

\item{path}{(\code{character})\cr path to the (sub)table represented by \code{tt}. Defaults to \code{character()}.}

\item{incontent}{(\code{flag})\cr internal detail, do not set manually.}

\item{repr_ext}{(\code{integer(1)})\cr internal detail, do not set manually.}

\item{repr_inds}{(\code{integer})\cr internal detail, do not set manually.}

\item{sibpos}{(\code{integer(1)})\cr internal detail, do not set manually.}

\item{nsibs}{(\code{integer(1)})\cr internal detail, do not set manually.}

\item{max_width}{(\code{numeric(1)} or \code{NULL})\cr maximum width for title/footer materials.}

\item{fontspec}{(\code{font_spec})\cr a font_spec object specifying the font information to use for
calculating string widths and heights, as returned by \code{\link[=font_spec]{font_spec()}}.}

\item{col_gap}{(\code{numeric(1)})\cr the gap to be assumed between columns, in number of spaces with
font specified by \code{fontspec}.}

\item{round_type}{(\code{"iec"} or \code{"sas"})\cr the type of rounding to perform. iec,
the default, peforms rounding compliant with IEC 60559 (see details), while
sas performs nearest-value rounding consistent with rounding within SAS.}
}
\value{
A \code{data.frame} of row/column-structure information used by the pagination machinery.
}
\description{
All relevant information about table rows (e.g. indentations) is summarized in a \code{data.frame}.
This function works \strong{only} on \code{rtables} and \code{rlistings} objects, and not on their \code{print} counterparts
(like \code{\link{MatrixPrintForm}}).
}
\details{
When \code{visible_only} is \code{TRUE} (the default), methods should return a \code{data.frame} with exactly one
row per visible row in the table-like object. This is useful when reasoning about how a table will
print, but does not reflect the full pathing space of the structure (though the paths which are given
will all work as is).

If supported, when \code{visible_only} is \code{FALSE}, every structural element of the table (in row-space)
will be reflected in the returned \code{data.frame}, meaning the full pathing-space will be represented
but some rows in the layout summary will not represent printed rows in the table as it is displayed.

Most arguments beyond \code{tt} and \code{visible_only} are present so that \code{make_row_df} methods can call
\code{make_row_df} recursively and retain information, and should not be set during a top-level call.
}
\note{
The technically present root tree node is excluded from the summary returned by
both \code{make_row_df} and \code{make_col_df} (see relevant functions in\code{rtables}), as it is the
row/column structure of \code{tt} and thus not useful for pathing or pagination.
}
\examples{
# Expected error with matrix_form. For real case examples consult {rtables} documentation
mf <- basic_matrix_form(iris)
# make_row_df(mf) # Use table obj instead

}
