% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FG_Server.R
\name{fers_builder}
\alias{fers_builder}
\title{Builds a Figure Element R Statement From UI Elements:}
\usage{
fers_builder(state)
}
\arguments{
\item{state}{FG state from \code{FG_fetch_state()}}
}
\value{
list containing the following elements
\itemize{
 \item{isgood:} Return status of the function.
 \item{cmd:}    ggplot R command as a character string
 \item{element:} The type of element being added
 \item{desc:}   Verbose description of the element
 \item{msgs:}   Messages to be passed back to the user
}
}
\description{
Takes the current ui elements and constructs the appropriate
ggplot commands forom the user input. The plot commands assume the existance
of a ggplot object \code{p}.
}
\examples{
\donttest{
sess_res = FG_test_mksession(session=list(), full_session=FALSE)
state = sess_res$state
fb_res = fers_builder(state)
}
}
