% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pacmacro_ranges.R
\name{pacmacro_ranges}
\alias{pacmacro_ranges}
\title{pacmacro_ranges}
\source{
Pacman procedure modified from https://rdrr.io/github/plannapus/CONOP9companion/src/R/pacman.R.
}
\usage{
pacmacro_ranges(
  x,
  rank = "genus",
  srt = "max_ma",
  end = "min_ma",
  step = 1,
  density = 0.1,
  top = 5,
  bottom = 5,
  tail.flag = 0.35,
  method = c("histogram", "kernel")
)
}
\arguments{
\item{x}{A stratigraphic occurrence dataset}

\item{rank}{The column name in x containing the taxon
names for which trimmed ranges will be calculated}

\item{srt}{A column name in x denoting the occurrence FADs}

\item{end}{A column name in x denoting the occurrence LADs}

\item{step}{A positive integer specifying the time window size
(i.e. the duration represented by each row in the output matrix)}

\item{density}{A positive numeric specifying the step size for
densifying records. This should ideally be smaller than step}

\item{top}{The percentage by which the top of the range will
be trimmed}

\item{bottom}{The percentage by which the bottom of the range
will be trimmed}

\item{tail.flag}{a numeric vector of proportions in the range
0 > x > 1 which will be used to test for long tails}

\item{method}{The method for quantifying occurrence density. By
default both histogram and kernel density will be used}
}
\value{
If the user specifies a specific method (e.g. method = "kernel"),
the returned value will be a data.frame containing the taxa as row names,
the original taxon ranges (FAD, LAD), their ranges as trimmed by the
specified value (default FAD95, LAD95), and the tail status (0 = none, 1 = tail)
at the user-specified tail proportions. If method is not specified, the result
will be a list of 2 data.frames, one for each method
}
\description{
Function to apply a modification of Pacman trimming to
macrofossil data. The function generates a densified
occurrence record using the same methods as \code{densify}
then trim the upper and lower ranges by a user-defined
percentage. The full and trimmed ranges are then
compared against each other to test if the FAD and the
LAD for a taxon form a long tail in its distribution.
Multiple tail thresholds can be supplied, but all test
to see if the sum of the FAD and LAD which exceeds the
trimmed range constitute the threshold proportion of the
total range for than taxon, e.g. does the FAD and the
LAD outside of the trimmed range comprise a quarter
(\code{tail.flag = 0.25}) of the taxon range?
}
\examples{
# load dataset
data("brachios")
# subsample brachios to make for a short example runtime
set.seed(1)
brachios <- brachios[sample(1:nrow(brachios), 1000),]
# run pacmacro
pacm <- pacmacro_ranges(brachios, tail.flag = c(0.3, 0.35, 0.4),
                        rank = "genus", srt = "max_ma", end = "min_ma")
}
\references{
Lazarus et al (2012) Paleobiology
}
