% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate_species_assessments.R
\name{locate_species_assessments}
\alias{locate_species_assessments}
\title{Index floristic quality assessments that include a given species}
\usage{
locate_species_assessments(species, database_id)
}
\arguments{
\item{species}{The scientific name of the target plant species}

\item{database_id}{A numeric identifier of the desired database, as specified
by \href{https://universalfqa.org/}{universalfqa.org}. The id numbers can
be viewed with the
\code{\link[=index_fqa_databases]{index_fqa_databases()}} function.}
}
\value{
A data frame with 5 columns:
\itemize{
  \item id (numeric)
  \item assessment (character)
  \item date (date)
  \item site (character)
  \item practitioner (character)
  }
}
\description{
For any given database, \code{locate_species_assessments()} produces a data
frame of all floristic quality assessments publicly available at
\href{https://universalfqa.org/}{universalfqa.org} that include the given
species.
}
\examples{
\donttest{
locate_species_assessments("Anemone canadensis", 2)
}

}
