% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_forest_profile.R
\name{build_forest_profile}
\alias{build_forest_profile}
\title{Construct a 2D Forest Profile Using L-System Trees from Inventory Data.}
\usage{
build_forest_profile(
  data,
  height,
  diameter,
  label,
  string = NULL,
  tree_model = "binary_tree",
  n_iter = NULL,
  angle = 15,
  crown_diameter = NULL,
  h_reduction = (1 + sqrt(5))/2 - 1,
  d_reduction = (1 + sqrt(5))/2 - 1,
  randomness = FALSE,
  angle_cv = 0.1,
  length_cv = 0.1,
  leaf_size = NULL,
  sample = TRUE,
  n_trees,
  dist = 3,
  dist_cv = 0
)
}
\arguments{
\item{data}{A data frame containing forest inventory data (field-measured or simulated). Each row represents an individual tree.}

\item{height}{Name of the column (character) containing tree heights, measured in meters.}

\item{diameter}{Name of the column (character) containing tree diameters, measured in centimeters.}

\item{label}{Name of the column (character) containing tree labels or unique IDs.}

\item{string}{The column (character) or string containing turtle graphics instructions generated by the \code{iterate_lsystem} function. If NULL (default), the \code{tree_model} argument is used to create instructions.}

\item{tree_model}{The predefined tree model to use when \code{string} is NULL. Accepts either an integer or a character string corresponding to a model name (e.g., 'binary_tree'). See \code{fractal_tree_model()} for details.}

\item{n_iter}{An integer specifying the number of iterations to generate the \code{tree_model} when \code{string} is NULL. Defaults to model-specific settings.}

\item{angle}{A numeric value specifying the branching angle (in degrees). Default is 15.}

\item{crown_diameter}{Column name (unquoted) or numeric value for the crown diameter of the trees. Default is NULL.}

\item{h_reduction}{A numeric value representing the reduction factor applied to branch lengths. Default is the golden ratio (\eqn{(1+\sqrt{5})/2 - 1}).}

\item{d_reduction}{A numeric value representing the reduction factor applied to branch diameters. Default is the golden ratio (\eqn{(1+\sqrt{5})/2 - 1}).}

\item{randomness}{A logical value. If set to TRUE, randomness is introduced to the branch angles. Default is FALSE.}

\item{angle_cv}{A numeric value specifying the coefficient of variation for branch angles, applied when \code{randomness} is set to TRUE. Default is 0.1.}

\item{length_cv}{A numeric value specifying the coefficient of variation for branch lengths, applied when \code{randomness} is set to TRUE. Default is 0.1.}

\item{leaf_size}{An unquoted column name or a numeric value specifying the size of the leaves. Defaults to NULL, in which case the \code{d_reduction} value is used.}

\item{sample}{A logical value. If TRUE, rows are sampled from data to construct the forest. The default is TRUE.}

\item{n_trees}{An integer specifying the number of trees to sample when \code{sample} is set to TRUE..}

\item{dist}{A numeric value representing the average linear distance between trees. The default is 3.}

\item{dist_cv}{A numeric value representing the coefficient of variation for tree distances. The default is 0.3.}
}
\value{
A data frame containing the 2D forest profile data, with individual tree id, component coordinates, component types, labels and diameters.
}
\description{
Construct a 2D Forest Profile Using L-System Trees from Inventory Data.
}
\details{
\itemize{
\item When \code{string} is specified, it must be a column in \code{data} containing turtle graphics strings for each tree.
\item If \code{sample} is TRUE, \code{n_trees} must be provided.
}
}
\examples{
# Example data
data <- data.frame(
  height = c(10, 12, 14, 12, 18, 15, 13, 16, 10, 8, 10, 7),
  diameter = c(12, 15, 11, 17, 25, 18, 10, 21, 12, 10, 10, 11),
  label = c("Tree1", "Tree2", "Tree3","Tree4", "Tree5", "Tree6",
            "Tree7", "Tree8", "Tree9", "Tree10", "Tree11", "Tree12")
)

# Build forest profile
build_forest_profile(
  data = data,
  height = height,
  diameter = diameter,
  label = label,
  tree_model = "binary_tree",
  n_trees = 3
)
}
