% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractionl.R
\name{Math.fractional}
\alias{Math.fractional}
\title{Method for the group generic function for the elementary mathematical functions}
\usage{
\method{Math}{fractional}(x, ...)
}
\arguments{
\item{x}{A numerical object flagged as \code{fractional}}

\item{...}{Passed on to further methods (but usually not required)}
}
\value{
A numeric object with the results of the computations, but NOT flagged
as of class \code{"fractional"}.
}
\description{
Allows graceful operations with mathematical functions.
}
\examples{
(M <- fractional(solve(cbind(1, contr.helmert(5)))))
(M0 <- abs(M)*sign(M))  ## fractional flag lost
}

