% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frailtyMM.R
\name{frailtyMM}
\alias{frailtyMM}
\title{Fitting frailty models with clustered, multi-event and recurrent data using MM algorithm}
\usage{
frailtyMM(
  formula,
  data,
  frailty = "gamma",
  power = NULL,
  tol = 1e-05,
  maxit = 200,
  ...
)
}
\arguments{
\item{formula}{Formula where the left hand side is an object of the type \code{Surv}
and the right hand side contains the variables and additional specifications. 
\code{+cluster()} function specify the group id for clustered data or individual id for recurrent data.
\code{+event()} function specify the event id for multi-event data (only two events are allowed).}

\item{data}{The \code{data.frame} where the formula argument can be evaluated.}

\item{frailty}{The frailty used for model fitting. The default is "lognormal", other choices are
"invgauss", "gamma" and "pvf". (Note that the computation time for PVF family will be slow 
due to the non-explicit expression of likelihood function)}

\item{power}{The power used if PVF frailty is applied.}

\item{tol}{The tolerance level for convergence.}

\item{maxit}{Maximum iterations for MM algorithm.}

\item{...}{additional arguments pass to the function.}
}
\value{
An object of class \code{fmm} that contains the following fields:
\item{coef}{coefficient estimated from a specific model.}
\item{est.tht}{frailty parameter estimated from a specific model.}
\item{lambda}{frailty for each observation estimated from a specific model.}
\item{likelihood}{The observed log-likelihood given estimated parameters.}
\item{input}{The input data re-ordered by cluster id. \code{y} is the event time, \code{X} is covariate matrix and \code{d} is the status while 0 indicates censoring.}
\item{frailty}{frailty used for model fitting.}
\item{power}{power used for model fitting is PVF frailty is applied.}
\item{iter}{total number of iterations.}
\item{convergence}{convergence threshold.}
\item{formula}{formula applied as input.}
\item{coefname}{name of each coefficient from input.}
\item{id}{id for individuals or clusters, {1,2...,a}. Note that, since the original id may not be the sequence starting from 1, this output
id may not be identical to the original id. Also, the order of id is corresponding to the returned \code{input}.}
\item{N}{total number of observations.}
\item{a}{total number of individuals or clusters.}
\item{datatype}{model used for fitting.}
}
\description{
{
This formula is used to fit the non-penalized regression. 3 types of the models can be fitted, shared frailty model where
hazard rate of \eqn{j^{th}} object in \eqn{i^{th}} cluster is
\deqn{\lambda_{ij}(t|\omega_i) = \lambda_0(t) \omega_i \exp(\boldsymbol{\beta}' \mathbf{X_{ij}}).}
The multi-event frailty model with different baseline hazard of different event and the hazard rate of \eqn{j^{th}} event for individual \eqn{i^{th}} is 
\deqn{\lambda_{ij}(t|\omega_i) = \lambda_{0j}(t) \omega_i \exp(\boldsymbol{\beta}' \mathbf{X_{ij}}).}
The recurrent event model where the \eqn{j^{th}} event of individual \eqn{i} has observed feature \eqn{\mathbf{X_{ij}}},
\deqn{\lambda_{ij}(t|\omega_i) = \lambda_0(t) \omega_i \exp(\boldsymbol{\beta}' \mathbf{X_{ij}}).}

For the  clustered type of data, we further assume that cluster \eqn{i} has \eqn{n_i} with \eqn{j=1,...,n_{i}} number 
of objects where they share the common frailty parameter \eqn{\omega_i}. For simplicity, we let \eqn{\boldsymbol{\alpha}} 
be the collection of all parameters and baseline hazard function. Then, the marginal likelihood is as follows,

\if{html}{\figure{fig1.png}{options: style="width:750px;max-width:75\%;"}}
\if{latex}{\out{\begin{center}}{\figure{fig1.png}{options: width=5in}}\out{\end{center}}}

Given the objective functions above, we take the clustered data as an example to illustrate the application of MM algorithm in optimizing the observed likelihood function,
the observed log-likelihood function is, 

\if{html}{\figure{fig4.png}{options: style="width:750px;max-width:75\%;"}}
\if{latex}{\out{\begin{center}}{\figure{fig4.png}{options: width=5in}}\out{\end{center}}}

where,

\if{html}{\figure{fig5.png}{options: style="width:750px;max-width:75\%;"}}
\if{latex}{\out{\begin{center}}{\figure{fig5.png}{options: width=5in}}\out{\end{center}}}

In order to formulate the iterative algorithm to optimize the observed log likelihood, we further define density function \eqn{g_i(\cdot)} 
based on the estimates of the parameters in \eqn{k^{th}} iteration \eqn{\boldsymbol{\alpha}^{(k)}}

\if{html}{\figure{fig6.png}{options: style="width:750px;max-width:75\%;"}}
\if{latex}{\out{\begin{center}}{\figure{fig6.png}{options: width=5in}}\out{\end{center}}}

Then, we construct the surrogate function to minimize the mariginal log-likelihood using the Jensen's inequality,

\if{html}{\figure{fig7.png}{options: style="width:750px;max-width:75\%;"}}
\if{latex}{\out{\begin{center}}{\figure{fig7.png}{options: width=5in}}\out{\end{center}}}

which successfully separated \eqn{\boldsymbol{\alpha}} into \eqn{\boldsymbol{\theta}} and \eqn{(\boldsymbol{\beta}, \Lambda_{0})} where,

\if{html}{\figure{fig8.png}{options: style="width:750px;max-width:75\%;"}}
\if{latex}{\out{\begin{center}}{\figure{fig8.png}{options: width=5in}}\out{\end{center}}}

and let \if{latex}{\figure{fig91.png}{options: width=2in}}\if{html}{\figure{fig91.png}{options: width=200}}, 

\if{html}{\figure{fig9.png}{options: style="width:750px;max-width:75\%;"}}
\if{latex}{\out{\begin{center}}{\figure{fig9.png}{options: width=5in}}\out{\end{center}}}

And then we estimate \eqn{\Lambda_{0}} by,

\if{html}{\figure{fig10.png}{options: style="width:750px;max-width:75\%;"}}
\if{latex}{\out{\begin{center}}{\figure{fig10.png}{options: width=5in}}\out{\end{center}}}

Then, we have, 

\if{html}{\figure{fig11.png}{options: style="width:750px;max-width:75\%;"}}
\if{latex}{\out{\begin{center}}{\figure{fig11.png}{options: width=5in}}\out{\end{center}}}

Further more, we apply hyperplane inequality to construct surrogate function for \eqn{\boldsymbol{\beta}} where we can update the its estimates coordinate wise,

\if{html}{\figure{fig12.png}{options: style="width:750px;max-width:75\%;"}}
\if{latex}{\out{\begin{center}}{\figure{fig12.png}{options: width=5in}}\out{\end{center}}}

By applying Jensen's inequality, 

\if{html}{\figure{fig13.png}{options: style="width:750px;max-width:75\%;"}}
\if{latex}{\out{\begin{center}}{\figure{fig13.png}{options: width=5in}}\out{\end{center}}}

Finally, 

\if{html}{\figure{fig14.png}{options: style="width:750px;max-width:75\%;"}}
\if{latex}{\out{\begin{center}}{\figure{fig14.png}{options: width=5in}}\out{\end{center}}}
}
}
\details{
To run the shared frailty model, \code{Surv(tstop, status)} formula should be applied along with \code{+cluster()} to specify the
corresponding clusters, if you want to run the simple frailty model without shared frailty, you do not need to use \code{+cluster()} and the
formula only contains the name of the covariates. To run the multi-event model, 
\code{Surv(tstop, status)} formula should be applied along with \code{+event()} to specify the corresponding events. If multi-event data
is fitted, please use {1,2...,K} to denote the event id from the input data. To run the recurrent event model, 
\code{Surv(tstart, tstop, status)} formula should be applied along with \code{+cluster()} where the cluster here denotes the individual id and
each individual may have many observed events at different time points.

The default frailty will be log-normal frailty, in order to fit other frailty models, simply set parameter \code{frailty} as "InvGauss", "Gamma" or "PVF",
the parameter \code{power} is only used when \code{frailty}=PVF and since the likelihood of PVF (tweedie) distribution is approximated using 
\code{Tweedie} function from package mgcv, 1<\code{power}<2.
}
\examples{

# Kidney data fitted by Clustered Inverse Gaussian Frailty Model

\donttest{
InvG_real_cl = frailtyMM(Surv(time, status) ~ age + sex + cluster(id),
                         kidney, frailty = "invgauss")
InvG_real_cl

# Cgd data fitted by Recurrent Log-Normal Frailty Model

logN_real_re = frailtyMM(Surv(tstart, tstop, status) ~ sex + treat + cluster(id),
                         cgd, frailty = "gamma")
logN_real_re
}

# Simulated data example

data(simdataCL)

# Parameter estimation under different model structure and frailties

# Clustered Gamma Frailty Model
gam_cl = frailtyMM(Surv(time, status) ~ . + cluster(id), 
                   simdataCL, frailty = "gamma")

\donttest{
# Clustered Log-Normal Frailty Model
logn_cl = frailtyMM(Surv(time, status) ~ . + cluster(id), 
                    simdataCL, frailty = "lognormal")

# Clustered Inverse Gaussian Frailty Model
invg_cl = frailtyMM(Surv(time, status) ~ . + cluster(id), 
                    simdataCL, frailty = "invgauss")
                   
data(simdataME)

# Multi-event Gamma Frailty Model
gam_me = frailtyMM(Surv(time, status) ~ . + cluster(id), 
                   simdataCL, frailty = "gamma")


# Multi-event Log-Normal Frailty Model
logn_me = frailtyMM(Surv(time, status) ~ . + event(id), 
                    simdataME, frailty = "lognormal")

# Multi-event Inverse Gaussian Frailty Model
invg_me = frailtyMM(Surv(time, status) ~ . + event(id),
                    simdataME, frailty = "invgauss")

data(simdataRE)

# Recurrent event Gamma Frailty Model
gam_re = frailtyMM(Surv(start, end, status) ~ . + cluster(id),
                   simdataRE, frailty = "gamma")

# Recurrent event Log-Normal Frailty Model
logn_re = frailtyMM(Surv(start, end, status) ~ . + cluster(id),
                   simdataRE, frailty = "lognormal")

# Recurrent event Inverse Gaussian Frailty Model
invg_re = frailtyMM(Surv(start, end, status) ~ . + cluster(id), 
                    simdataRE, frailty = "invgauss")
}

# Obtain the summary statistics under fitted model

coef(gam_cl)
summary(gam_cl)

}
\references{
\itemize{
\item Huang, X., Xu, J. and Zhou, Y. (2022). Profile and Non-Profile MM Modeling of Cluster Failure Time and Analysis of ADNI Data. \emph{Mathematics}, 10(4), 538.
\item Huang, X., Xu, J. and Zhou, Y. (2023). Efficient algorithms for survival data with multiple outcomes using the frailty model. \emph{Statistical Methods in Medical Research}, 32(1), 118-132.
}
}
