% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jointSurroTKendall.R
\name{jointSurroTKendall}
\alias{jointSurroTKendall}
\title{Kendall's \eqn{\tau} estimation using numerical integration methods}
\usage{
jointSurroTKendall(object = NULL, theta, gamma, alpha = 1, zeta = 1, 
                   sigma.v = matrix(rep(0,4),2,2), int.method = 0, 
                   nb.MC.kendall = 10000, nb.gh = 32, random.generator = 1, 
                   random = 0, random.nb.sim = 0, seed = 0, ui = 1)
}
\arguments{
\item{object}{An object inheriting from \code{jointSurroPenal} class. The default is \code{NULL}}

\item{theta}{Variance of the individual-level random effect, \eqn{\omega_{ij}}. 
Required if \code{object} is set to \code{NULL}}

\item{gamma}{Variance of the trial-level random effect associated with the baseline risk, \eqn{u_i}. 
Required if \code{object} is set to \code{NULL}. The default is \code{3.5}.}

\item{alpha}{Power parameter associated with \eqn{u_i}. Required if \code{object} is set to \code{NULL}.
The default is \code{1}.}

\item{zeta}{Power parameter associated with \eqn{\omega_{ij}}. Required if \code{object} is set to \code{NULL} 
The default is \code{1}.}

\item{sigma.v}{Covariance matrix  of the random effects treatment-by-trial interaction \eqn{(v_{S_i},v_{T_i})}}

\item{int.method}{A numeric, indicates the integration method: \code{0} for Monte carlo and 
\code{1} for Gaussian-Hermite quadrature. The default is \code{0}}

\item{nb.MC.kendall}{Number of generated points used with the Monte-Carlo to estimate
integrals in the Kendall's \eqn{\tau} formulation. Beter to use at least 4000 points for
stable reseults. The default is \code{10000}.}

\item{nb.gh}{Number of nodes for the Gaussian-Hermite quadrature.  The default is \code{32}.}

\item{random.generator}{Random number generator to use by the Fortran compiler, 
\code{1} for the intrinsec subroutine \code{Random_number} and \code{2} for the 
subroutine \code{uniran()}. The default is \code{1}.}

\item{random}{A binary that says if we reset the random number generation with a different environment 
at each call \code{(1)} or not \code{(0)}. If it is set to \code{1}, we use the computer clock 
as a seed. In the last case, it is not possible to reproduce the generated datesets". 
The default is \code{0}.}

\item{random.nb.sim}{If \code{random} is set to \code{1}, a binary that indicates the number 
of generations that will be made.}

\item{seed}{The seed to use for data (or samples) generation. required if \code{random} is set to \code{0}. 
The default is \code{0}.}

\item{ui}{A binary, indicates whether one considered trial random effect associated with 
the baseline risk (\code{1}) or not (\code{0}). The default is \code{1}.}
}
\value{
This function return the estimated Kendall's \eqn{\tau}
}
\description{
This function estimate the Kendall's \eqn{\tau} based on the joint surrogate model 
described in \link{jointSurroPenal} (Sofeu \emph{et al.}, 2018), for the evaluation of 
a candidate surrogate endpoints, at the individual-level . We used the Monte-carlo and the gaussian Hermite 
quadrature methods for numerical integration. In case of Gaussian Hermite quadrature, 
it is better to choose at least \code{20} quadature nodes for better results. 
The actual value of nodes used is the maximum between \code{20} and \code{nb.gh}
}
\examples{
Ktau1 <- jointSurroTKendall(theta = 3.5, gamma = 2.5, nb.gh = 32)
Ktau2 <- jointSurroTKendall(theta = 1, gamma = 0.8, alpha = 1, zeta = 1, nb.gh = 32)

###---Kendall's \\eqn{\\tau} from a joint surrogate model ---###

data.sim <-jointSurrSimul(n.obs=400, n.trial = 20,cens.adm=549, 
          alpha = 1.5, theta = 3.5, gamma = 2.5, zeta = 1, 
          sigma.s = 0.7, sigma.t = 0.7,rsqrt = 0.8, betas = -1.25, 
          betat = -1.25, full.data = 0, random.generator = 1, 
          seed = 0, nb.reject.data = 0)
          
\dontrun{
###---Estimation---###
joint.surrogate <- jointSurroPenal(data = data.sim, nb.mc = 300, 
                   nb.gh = 20, indice.alpha = 1, n.knots = 6)
                   
 Ktau3 <- jointSurroTKendall(joint.surrogate)
 Ktau4 <- jointSurroTKendall(joint.surrogate,nb.MC.kendall = 4000,seed = 1)
}

}
\references{
Sofeu C.L., Emura T. and Rondeau V. (2018). One-step validation method for surrogate 
endpoints in multiple randomized cancer clinical trials with failure-time endpoints. 
\code{Under review}
}
\seealso{
\code{\link{jointSurrSimul}}, \code{\link{summary.jointSurroPenal}}
}
\author{
Casimir Ledoux Sofeu \email{casimir.sofeu@u-bordeaux.fr}, \email{scl.ledoux@gmail.com} and 
Virginie Rondeau \email{virginie.rondeau@inserm.fr}
}
