% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.jointSurroPenal.R
\name{print.jointSurroPenal}
\alias{print.jointSurroPenal}
\title{Summary of the random effects parameters, the fixed treatment 
effects, and the surrogacy evaluation criteria estimated from a joint surrogate model}
\usage{
\method{print}{jointSurroPenal}(x, d = 4, len = 3, nb.gh = 32, ...)
}
\arguments{
\item{x}{An object inheriting from \code{jointSurroPenal} class.}

\item{d}{The desired number of digits after the decimal point for parameters. 
The maximum of 4 digits is required for the estimates. Default of 3 digits is used.}

\item{len}{The desired number of digits after the decimal point for p-value and convergence 
criteria. Default of 4 digits is used.}

\item{nb.gh}{Number of nodes for the Gaussian-Hermite quadrature.  The default is \code{32}
\code{1} for Gaussian-Hermite quadrature.}

\item{\dots}{other unused arguments.}
}
\value{
For the variances parameters of the random effects, it prints the estimate of
the coefficients with their standard error, Z-statistics and p-values
of the Wald test. For the fixed treatment effects, it also prints HR and its confidence
intervals for each covariate. For the surrogacy evaluation criteria, its prints the estimated 
Kendall's \eqn{\tau} with its 95\% Confidence interval obtained by the parametric bootstrap
 or Delta-method, 
the estimated \if{latex}{\eqn{R^2_{trial}}}
   \if{html}{\code{R}\out{<sup>2</sup><sub>trial</sub>}}(R2trial) with standard error and the 95\% Confidence interval 
obtained by Delta-method (Dowd \emph{et al.}, 2014), \if{latex}{\eqn{R^2_{trial}}}
   \if{html}{\code{R}\out{<sup>2</sup><sub>trial</sub>}}(R2.boot) and its 95\% 
Confidence interval obtained by the parametric bootstrap. 
We notice that, using bootstrap, 
the standard error of the point estimate is not available. We propose a classification of \if{latex}{\eqn{R^2_{trial}}}
   \if{html}{\code{R}\out{<sup>2</sup><sub>trial</sub>}} according to 
the suggestion of the Institute of Quality and Efficiency in Health Care 
(Prasad \emph{et al.}, 2015). 
We also display the surrogate threshold effect (\code{\link[=ste]{ste}}) with the associated hazard risk.
The rest of parameters concerns the convergence characteristics and 
included: the penalized marginal log-likelihood, the number of iterations, the LCV and the Convergence criteria.
}
\description{
This function returns the estimate of the coefficients and their standard error with p-values 
of the Wald test for the joint surrogate model, also hazard ratios (HR) and their 
confidence intervals for the fixed treatment effects, and finaly an estimate of the 
surrogacy evaluation criterian (Kendall's \eqn{\tau} and \if{latex}{\eqn{R^2_{trial}}}
   \if{html}{\code{R}\out{<sup>2</sup><sub>trial</sub>}})
}
\examples{


\dontrun{

###---Data generation---###
data.sim <-jointSurrSimul(n.obs=400, n.trial = 20,cens.adm=549, 
          alpha = 1.5, theta = 3.5, gamma = 2.5, zeta = 1, 
          sigma.s = 0.7, sigma.t = 0.7, cor = 0.8, betas = -1.25, 
          betat = -1.25, full.data = 0, random.generator = 1, 
          seed = 0, nb.reject.data = 0)

###---Estimation---###
joint.surrogate <- jointSurroPenal(data = data.sim, nb.mc = 300, 
                   nb.gh = 20, indicator.alpha = 1, n.knots = 6)
                            
print(joint.surrogate)

# or
joint.surrogate
}


}
\references{
Dowd BE, Greene WH, Norton EC (2014). "Computation of Standard Errors." Health Services
Research, 49(2), 731-750.

Prasad V, Kim C, Burotto M, Vandross A (2015). "The strength of association between
surrogate end points and survival in oncology: A systematic review of trial-level meta-
alyses." JAMA Internal Medicine, 175(8), 1389-1398.
}
\seealso{
\code{\link{jointSurroPenal}, \link{jointSurroCopPenal}, \link{jointSurroTKendall}}
}
\author{
Casimir Ledoux Sofeu \email{casimir.sofeu@u-bordeaux.fr}, \email{scl.ledoux@gmail.com} and 
Virginie Rondeau \email{virginie.rondeau@inserm.fr}
}
\keyword{methods}
