% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_category_children.R
\name{fredr_category_children}
\alias{fredr_category_children}
\title{Get the child categories for a specified FRED parent category}
\usage{
fredr_category_children(category_id = 0L, realtime_start = NULL,
  realtime_end = NULL)
}
\arguments{
\item{category_id}{An integer ID for the category.  Default is \code{0} for the
root category. \emph{Required parameter.}}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://research.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://research.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object containing the name and ID for the children categories
of the parent category indicated by \code{category_id}.
}
\description{
Get the child categories for a specified FRED parent category
}
\section{API Documentation}{


\href{https://research.stlouisfed.org/docs/api/fred/category_children.html}{fred/category/children}
}

\examples{
\donttest{
# Children of the root category
fredr_category_children(category_id = 0L)
# Children of the "Production & Business Activity" category
fredr_category_children(category_id = 1L)
}
}
\seealso{
\code{\link[=fredr_category]{fredr_category()}}, \code{\link[=fredr_category_related]{fredr_category_related()}},
\code{\link[=fredr_category_series]{fredr_category_series()}}, \code{\link[=fredr_category_tags]{fredr_category_tags()}}, \code{\link[=fredr_category_related_tags]{fredr_category_related_tags()}}
}
