% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk.R
\name{adjusted_risk}
\alias{adjusted_risk}
\title{adjusted_risk}
\usage{
adjusted_risk(prop, RR)
}
\arguments{
\item{prop}{A vector of proportions of the population that belong
to each URG (Unit risk group)}

\item{RR}{A vector of the relative risks of for each URG. The
first of these is the referent group and therefore must be
equal to 1}
}
\value{
A vector of Adjusted risks
}
\description{
Adjusted Risk
}
\details{
Calculate the adjusted risk for each of the unit risk groups
(URG). This can be used at both the herd and the animal level. The
proportion vector, for herd level, is therefore the proportion
herds in the population that are in each of the unit risk
groups. The proportion vector for animal level is the proportion
of animals within a given herd that are in each URG.
}
\examples{
df <- sample_data(nherds = 100,
                 mean_herd_size = 300,
                 n_herd_urg = 2,
                 herd_dist = c(0.9, 0.1),
                 herd_samp_frac = 0.01,
                 herd_samp_dist = c(0.3, 0.7),
                 n_animal_urg = 1,
                 animal_dist = c(1),
                 animal_samp_frac = 0.05,
                 animal_samp_dist = c(1),
                 seed = 1)
## The proportion of herds in each unit risk group
table(df$herd_urg)/nrow(df)
## Calculate the Adjusted risk for each unit risk group based on the
## proportion in each group and the estimated relative risk of being
## in that group:
AR <- freedom::adjusted_risk(as.numeric(table(df$herd_urg)/nrow(df)),
                             c(1, 2.3))
}
