% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fts.plot.filters.R
\name{fts.plot.filters}
\alias{fts.plot.filters}
\title{Plot kernels}
\usage{
fts.plot.filters(A, Ndpc = 1, lags = -3:3, one.plot = FALSE, ...)
}
\arguments{
\item{A}{a functional filter sequence given as object of class \code{\link{fts.timedom}}.}

\item{Ndpc}{if Ndpc = k the first k filter sequences are plotted.}

\item{lags}{number of lags to plot.}

\item{one.plot}{if TRUE then functional filters corresponding belonging to the respective scores will all be plotted in the same graph.}

\item{...}{arguments \code{col, lwd, lty} passed to \code{plot}}
}
\description{
Plot kernels
}
\examples{
# Load example PM10 data from Graz, Austria
data(pm10) # loads functional time series pm10 to the environment
X = center.fd(pm10)

# Compute functional dynamic principal components with only one component
res.dpca = fts.dpca(X, Ndpc = 1, freq=(-25:25/25)*pi) # leave default freq for higher precision

# Plot Functional Dynamic Principal Component Filters
fts.plot.filters(res.dpca$filters)
}
\keyword{plotting}
