% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_navbar}
\alias{bs_vars_navbar}
\title{Bootstrap CSS navbar variables}
\usage{
bs_vars_navbar(height = NULL, margin_bottom = NULL,
  default_color = NULL, default_bg = NULL, default_border = NULL,
  default_link_color = NULL, default_link_active_color = NULL,
  default_link_active_bg = NULL, default_link_hover_color = NULL,
  default_link_hover_bg = NULL, inverse_color = NULL,
  inverse_bg = NULL, inverse_border = NULL,
  inverse_link_color = NULL, inverse_link_active_color = NULL,
  inverse_link_active_bg = NULL, inverse_link_hover_color = NULL,
  inverse_link_hover_bg = NULL)
}
\arguments{
\item{height}{Height of the navbar, e.g. \code{"50px"} (the default in Bootstrap).}

\item{margin_bottom}{Bottom margin of navbar.}

\item{default_color}{Color of text in the navbar.}

\item{default_bg}{Background color of the navbar.}

\item{default_border}{Border color of the navbar.}

\item{default_link_color}{Link color.}

\item{default_link_active_color}{Color for active link (selected tab).}

\item{default_link_active_bg}{Background color for active link (selected tab).}

\item{default_link_hover_color}{Color of links when hovered.}

\item{default_link_hover_bg}{Background color of links when hovered.}

\item{inverse_color}{Color of text for inversed navbar.}

\item{inverse_bg}{Background color for inversed navbar.}

\item{inverse_border}{Border color for inversed navbar.}

\item{inverse_link_color}{Link color for inversed navbar.}

\item{inverse_link_active_color}{Color for active link (selected tab) for inversed navbar.}

\item{inverse_link_active_bg}{Background color for active link (selected tab) for inversed navbar.}

\item{inverse_link_hover_color}{Color of links when hovered for inversed navbar.}

\item{inverse_link_hover_bg}{Background color of links when hovered for inversed navbar.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 navigation bar component (e.g. \code{\link[shiny:navbarPage]{shiny::navbarPage}}) in Bootstrap and Bootswatch themes.
}
\note{
See default parameters for Bootstrap: \url{https://getbootstrap.com/docs/3.4/customize/}.
}
\examples{
# Change background color of the navbar
bs_vars_navbar(
  default_bg = "#75b8d1",
  default_color = "#FFFFFF",
  default_link_color = "#FFFFFF",
  default_link_active_color = "#FFFFFF"
)

if (interactive()) {
  library(shiny)

  ui <- navbarPage(
    title = "Custom navbar",
    header = use_theme(
      create_theme(
        theme = "default",
        bs_vars_navbar(
          default_bg = "#75b8d1",
          default_color = "#FFFFFF",
          default_link_color = "#FFFFFF",
          default_link_active_color = "#75b8d1",
          default_link_active_bg = "#FFFFFF",
          default_link_hover_color = "firebrick"

        ),
        output_file = NULL
      )
    ),
    tabPanel("Tab 1"),
    tabPanel("Tab 2")
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
