% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sloboba.R
\name{sloboda}
\alias{sloboda}
\title{Sloboda's Growth Function}
\usage{
sloboda(a, b, c, y0, t0, t, type = c("classic", "kaendler"), k = 65)
}
\arguments{
\item{a}{Sloboda's \eqn{\beta_{3}}.}

\item{b}{Sloboda's \eqn{\beta_{2}}.}

\item{c}{Sloboda's \eqn{\beta_{1}}.}

\item{y0}{Sloboda's \eqn{\beta_{1}}.}

\item{t0}{Sloboda's \eqn{t_{0}}.}

\item{t}{Sloboda's \eqn{t}.}

\item{type}{Gerald Kaendler reformulated the algorithm, but it doesn't get
faster, see the examples.}

\item{k}{Sloboda's \eqn{k}.}
}
\value{
The value \eqn{y_t} of Sloboda's growth function.
}
\description{
Implement the growth function
  \deqn{
    y_t = k^{\beta_{1}} \times \left(\frac{y_0}{k^{\beta_{1}}}\right)^{\exp
        \left[
            \frac{\beta_{2}}{(\beta_{3}-1) \times t ^{(\beta_{3}-1)}} -
            \frac{\beta_{2}}{(\beta_{3}-1) \times t_0 ^{(\beta_{3}-1)}}
    \right]
    }
  }{%
    y_t = k^{beta_{1}} (y_{0} / (k^{beta_{1}}))^\exp(
            beta_{2}/((beta_{3}-1) t^(beta_{3}-1)) -
            beta_{2}/((beta_{3}-1) t_0^(beta_{3}-1)))
}
published in 
\cite{Sloboda, B., 1971: Zur Darstellung von Wachstumsprozessen mit Hilfe von
Differentialgleichungen erster Ordnung. Mitt. d. Baden-Württembergischen
Forstlichen Versuchs- und Forschungsanstalt}.
}
\examples{
microbenchmark::microbenchmark(cl = sloboda(0.2, 0.7, 3, 30, 30, 35),
                               g =  sloboda(0.2, 0.7, 3, 30, 30, 35,
                                            "kaendler"),
                               check = "equivalent")
}
\seealso{
Other statistics: 
\code{\link{column_sums}()},
\code{\link{count_groups}()},
\code{\link{relative_difference}()},
\code{\link{round_half_away_from_zero}()},
\code{\link{weighted_variance}()}
}
\concept{statistics}
