% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.subject.label}
\alias{vis.subject.label}
\title{Visualize a label for a subject.}
\usage{
vis.subject.label(subjects_dir, subject_id, label, hemi,
  surface = "white", colormap = squash::rainbow2, views = c("t4"),
  rgloptions = list(), rglactions = list(), draw_colorbar = FALSE)
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id, }{string. The subject identifier.
T}

\item{label, }{string. Name of the label file, without the hemi part (if any), but including the '.label' suffix. E.g., 'cortex.label' for '?h.cortex.label'.}

\item{hemi, }{string, one of 'lh', 'rh', or 'both'. The hemisphere name. Used to construct the names of the label data files to be loaded.}

\item{surface, }{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{colormap, }{a colormap. See the squash package for some colormaps. Defaults to [squash::rainbow2].}

\item{views, }{list of strings. Valid entries include: 'si': single interactive view. 't4': tiled view showing the brain from 4 angles. 't9': tiled view showing the brain from 9 angles.}

\item{rgloptions}{option list passed to [rgl::par3d()]. Example: rgloptions = list("windowRect"=c(50,50,1000,1000));}

\item{rglactions, }{named list. A list in which the names are from a set of pre-defined actions. The values can be used to specify parameters for the action.}

\item{draw_colorbar}{logical, whether to draw a colorbar. WARNING: The colorbar is drawn to a subplot, and this only works if there is enough space for it. You will have to increase the plot size using the 'rlgoptions' parameter for the colorbar to show up. Defaults to FALSE.}
}
\value{
list of coloredmeshes. The coloredmeshes used for the visualization.
}
\description{
Visualize a label for a subject. A label is jsut a logical vector with one entry for each vertex in the mesh.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   subject_id = 'subject1';
   surface = 'white';
   hemi = 'both';
   label = 'cortex.label';
   vis.subject.label(subjects_dir, subject_id, label, hemi);
}

}
\seealso{
Other visualization functions: \code{\link{vis.data.on.fsaverage}},
  \code{\link{vis.data.on.subject}},
  \code{\link{vis.region.values.on.subject}},
  \code{\link{vis.subject.annot}},
  \code{\link{vis.subject.morph.native}},
  \code{\link{vis.subject.morph.standard}}
}
\concept{label functions}
\concept{visualization functions}
