% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_multiview.R
\name{brainview.sr}
\alias{brainview.sr}
\title{Visualize a list of colored meshes, rotating the camera around them.}
\usage{
brainview.sr(coloredmeshes, background = "white", skip_all_na = TRUE,
  style = "default", draw_labels = FALSE, x = 0, y = 1, z = 0,
  rpm = 6, duration = 10, rgloptions = list(), rglactions = list(),
  draw_colorbar = FALSE)
}
\arguments{
\item{coloredmeshes, }{list of coloredmesh. A coloredmesh is a named list as returned by the coloredmesh.from.* functions. It has the entries 'mesh' of type tmesh3d, a 'col', which is a color specification for such a mesh.}

\item{background}{string, background color passed to \code{\link[rgl]{bg3d}}.}

\item{skip_all_na}{logical, whether to skip (i.e., not render) meshes in the list that have the property 'morph_data_was_all_na' set to TRUE. Defaults to TRUE. Practically, this means that a hemisphere for which the data was not given is not rendered, instead of being rendered in a single color.}

\item{style, }{a named list of style parameters or a string specifying an available style by name (e.g., 'shiny'). Defaults to 'default', the default style.}

\item{draw_labels}{logical, whether to draw label text for the different views that show information on the view direction and hemisphere displayed in a subplot. Defaults to FALSE.}

\item{x}{rotation x axis value, passed to \code{\link[rgl]{spin3d}}. Defaults to 0.}

\item{y}{rotation y axis value, passed to \code{\link[rgl]{spin3d}}. Defaults to 1.}

\item{z}{rotation z axis value, passed to \code{\link[rgl]{spin3d}}. Defaults to 0.}

\item{rpm}{rotation rpm value, passed to \code{\link[rgl]{spin3d}}. Defaults to 15.}

\item{duration}{rotation duration value, passed to \code{\link[rgl]{spin3d}}. Defaults to 20.}

\item{rgloptions, }{named list. Parameters passed to \code{\link[rgl]{par3d}}. Defaults to the empty list.}

\item{rglactions, }{named list. A list in which the names are from a set of pre-defined actions. Defaults to the empty list.}

\item{draw_colorbar}{logical, whether to draw a colorbar. WARNING: The colorbar is drawn to a subplot, and this only works if there is enough space for it. You will have to increase the plot size using the 'rlgoptions' parameter for the colorbar to show up. Defaults to FALSE.}
}
\description{
Visualize a list of colored meshes, rotating the camera around them.
}
\keyword{internal}
