% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.subject.morph.standard}
\alias{vis.subject.morph.standard}
\title{Visualize native space morphometry data for a subject or a group.}
\usage{
vis.subject.morph.standard(
  subjects_dir,
  subject_id,
  measure,
  hemi = "both",
  fwhm = "10",
  surface = "white",
  template_subject = "fsaverage",
  template_subjects_dir = NULL,
  colormap = NULL,
  views = c("t4"),
  rgloptions = rglot(),
  rglactions = list(),
  draw_colorbar = FALSE,
  cortex_only = FALSE,
  makecmap_options = mkco.seq(),
  bg = NULL
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{character string or vector of character strings, the subject or subjects. For a single subjects, its data will be plotted. If a group of subjects is given instead, at each vertex the mean value over all the subjects will be plotted.}

\item{measure}{string. The morphometry data to use. E.g., 'area' or 'thickness'. Pass NULL to render just the surface in white, without any data.}

\item{hemi}{string, one of 'lh', 'rh', or 'both'. The hemisphere name. Used to construct the names of the label data files to be loaded.}

\item{fwhm}{string, smoothing setting (full width at half maximum of the kernel). The smoothing part of the filename, typically something like '0', '5', '10', ...,  or '25'.}

\item{surface}{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{template_subject}{The template subject used. This will be used as part of the filename, and its surfaces are loaded for data visualization. Defaults to 'fsaverage'.}

\item{template_subjects_dir}{The template subjects dir. If NULL, the value of the parameter 'subjects_dir' is used. If you have FreeSurfer installed and configured, and are using the standard fsaverage subject, try passing the result of calling 'file.path(Sys.getenv('FREESURFER_HOME'), 'subjects')'.}

\item{colormap}{a colormap function. **DEPRECATED**: use parameter 'makecmap_options' instead, like this: \code{makecmap_options=list('colFn'=terrain.colors)}.}

\item{views}{list of strings. Valid entries include: 'si': single interactive view. 't4': tiled view showing the brain from 4 angles. 't9': tiled view showing the brain from 9 angles.}

\item{rgloptions}{option list passed to \code{\link{par3d}}. Example: \code{rgloptions = list("windowRect"=c(50,50,1000,1000))}.}

\item{rglactions}{named list. A list in which the names are from a set of pre-defined actions. The values can be used to specify parameters for the action. The following example clips outliers in the data before plotting and writes a screenshot in PNG format: \code{rglactions = list("snapshot_png"="~/fsbrain.png", "clip_data"=c(0.05, 0.95))}.}

\item{draw_colorbar}{logical or one of the character strings 'vertical' or 'horizontal', whether to draw a colorbar. Notice: the colorbar is drawn to a separate subplot, and this only works if there is enough space for it, i.e., the plot resolution must be high enough. You may have to increase the plot size for the colorbar to show up, see the vignette for instructions. Defaults to `FALSE`. See  \code{\link[fsbrain]{coloredmesh.plot.colorbar.separate}} for an alternative.}

\item{cortex_only}{logical, whether to mask the medial wall, i.e., whether the morphometry data for all vertices which are *not* part of the cortex (as defined by the label file `label/?h.cortex.label`) should be replaced with NA values. In other words, setting this to TRUE will ignore the values of the medial wall between the two hemispheres. If set to true, the mentioned label file needs to exist for the subject. Defaults to FALSE.}

\item{makecmap_options}{named list of parameters to pass to \code{\link{makecmap}}. Must not include the unnamed first parameter, which is derived from 'measure'. Should include at least a colormap function as name 'colFn'.}

\item{bg}{a background definition. Can be a surface color layer or a character string, see \code{\link[fsbrain]{collayer.bg}} for valid strings.}
}
\value{
list of coloredmeshes. The coloredmeshes used for the visualization.
}
\description{
Renders standard space morphometry data for a single subject, or the group mean for a group of subjects. The default template subject is fsaverage.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   fsaverage_dir = file.path(Sys.getenv('FREESURFER_HOME'), 'subjects');
   if(dir.exists(fsaverage_dir)) {
       vis.subject.morph.standard(subjects_dir, 'subject1', 'thickness', 'lh',
       '10', template_subjects_dir=fsaverage_dir);
   }
   # The last command will load the file
   #  *<subjects_dir>/subject1/surf/lh.thickness.fwhm10.fsaverage.mgh* and
   #  visualize the data on *$FREESURFER_HOME/subjects/fsaverage/surf/lh.white*.
}

}
\seealso{
Other visualization functions: 
\code{\link{vis.color.on.subject}()},
\code{\link{vis.data.on.fsaverage}()},
\code{\link{vis.data.on.subject}()},
\code{\link{vis.labeldata.on.subject}()},
\code{\link{vis.mask.on.subject}()},
\code{\link{vis.region.values.on.subject}()},
\code{\link{vis.subject.annot}()},
\code{\link{vis.subject.label}()},
\code{\link{vis.subject.morph.native}()},
\code{\link{vis.symmetric.data.on.subject}()},
\code{\link{vislayout.from.coloredmeshes}()}

Other morphometry visualization functions: 
\code{\link{vis.data.on.fsaverage}()},
\code{\link{vis.data.on.subject}()},
\code{\link{vis.subject.morph.native}()},
\code{\link{vis.symmetric.data.on.subject}()}
}
\concept{morphometry visualization functions}
\concept{visualization functions}
