% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodesic.R
\name{geod.vert.neighborhood}
\alias{geod.vert.neighborhood}
\title{Compute all vertices within given geodesic distance on the mesh.}
\usage{
geod.vert.neighborhood(
  mesh,
  vertex,
  max_distance = 5,
  include_max = TRUE,
  return_distances = TRUE
)
}
\arguments{
\item{mesh}{an instance of \code{rgl::tmesh3d} or \code{freesurferformats::fs.surface}.}

\item{vertex}{positive integer (or vector of the latter), the index of the source vertex in the mesh. If a vector, the neighborhoods for all vertices will be computed separately.}

\item{max_distance}{double, the neighborhood size. All mesh vertices in geodesic distance smaller than / up to this distance will be returned.}

\item{include_max}{logical, whether the max_distance value is inclusive.}

\item{return_distances}{logical, whether to compute the 'distances' entry in the returned list. Doing so is a little bit slower, so it can be turned off if not needed.}
}
\value{
named list with the following entries: 'vertices': integer vector, the indices of all vertices in the neigborhood. 'distances': double vector, the distances to the respective vertices (unless 'return_distances' is FALSE).
}
\description{
Compute all vertices within given geodesic distance on the mesh.
}
\note{
This function uses the pseudo-geodesic distance along the mesh edges.
}
\examples{
\dontrun{
  sjd = fsaverage.path(TRUE);
  surface = subject.surface(sjd, 'fsaverage', surface = "white", hemi = "lh");
  res = geod.vert.neighborhood(surface, 12345L, max_distance = 10.0);
  res$vertices;
}

}
\keyword{internal}
