% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_surface_background.R
\name{desaturate}
\alias{desaturate}
\title{Perform simple desaturation or grayscale conversion of RGBA colors.}
\usage{
desaturate(color, gamma_correct = FALSE)
}
\arguments{
\item{color}{rgba color strings}

\item{gamma_correct}{logical, whether to apply non-linear gamma correction. First performs gamma expansion, then applies the gray-scale channel weigths, then gamma compression.}
}
\value{
rgba color strings, the grayscale colors. The information from one of the three rgb channels would be enough. The alpha value is not touched.
}
\description{
Perform simple desaturation or grayscale conversion of RGBA colors.
}
\note{
Assumes sRGB color space.
}
\references{
see https://en.wikipedia.org/wiki/Grayscale#Converting_color_to_grayscale
}
\seealso{
Other color functions: 
\code{\link{alphablend}()}
}
\concept{color functions}
