% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fude.R
\name{read_fude}
\alias{read_fude}
\title{Read a Fude Polygon ZIP file}
\usage{
read_fude(path, quiet = FALSE)
}
\arguments{
\item{path}{Path to the ZIP file containing one or more GeoJSON format files.}

\item{quiet}{logical. Suppress information about the data to be read.}
}
\value{
A list of \code{\link[sf:sf]{sf::sf()}} objects.
}
\description{
\code{read_fude()} reads Fude Polygon data as a list. The data can be downloaded
from the MAFF website as a ZIP file, which contains one or more GeoJSON
format files. The function should also work with the ZIP file you created,
as long as you do not change the filenames of the original GeoJSON files.
}
\examples{
path <- system.file("extdata", "castle.zip", package = "fude")
d <- read_fude(path)
}
