% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_fude.R
\name{rename_fude}
\alias{rename_fude}
\title{Rename the Fude Polygon data}
\usage{
rename_fude(data, suffix = TRUE, romaji = NULL, quiet = FALSE)
}
\arguments{
\item{data}{List of \code{\link[sf:sf]{sf::sf()}} objects.}

\item{suffix}{logical. If \code{FALSE}, suffixes such as "SHI" and "KU" in local government
names are removed.}

\item{romaji}{If not \code{NULL}, rename the local government name in romaji instead of
Japanese. Romanji format is upper case unless specified.
\itemize{
\item \code{"title"}: Title case.
\item \code{"lower"}: Lower case.
\item \code{"upper"}: Upper case.
}}

\item{quiet}{logical. Suppress information about the data to be read.}
}
\value{
A list of \code{\link[sf:sf]{sf::sf()}} objects.
}
\description{
\code{rename_fude()} renames the local government code of the list returned by
\code{\link[=read_fude]{read_fude()}} to the corresponding Japanese name in order to make the data
human-friendly.
}
\examples{
path <- system.file("extdata", "castle.zip", package = "fude")
d <- read_fude(path, quiet = TRUE)
d2 <- rename_fude(d)
d2 <- rename_fude(d, suffix = FALSE)
d2 <- d |> rename_fude(romaji = "upper")
}
\seealso{
\code{\link[=read_fude]{read_fude()}}.
}
