% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_fude.R
\name{bind_fude}
\alias{bind_fude}
\title{Bind multiple Fude Polygon data}
\usage{
bind_fude(...)
}
\arguments{
\item{...}{Database lists to be combined. They should all have the same named
elements.}
}
\value{
A list of \code{\link[sf:sf]{sf::sf()}} object(s).
}
\description{
\code{bind_fude()} binds a list of polygon data. It also binds a list of data
combined by \code{\link[=combine_fude]{combine_fude()}}.
}
\examples{
path <- system.file("extdata", "castle.zip", package = "fude")
d1 <- read_fude(path, stringsAsFactors = FALSE, quiet = TRUE)
d2 <- read_fude(path, stringsAsFactors = FALSE, quiet = TRUE)
bind_fude(d1, d2)

}
\seealso{
\code{\link[=read_fude]{read_fude()}}, \code{\link[=combine_fude]{combine_fude()}}.
}
