% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ft_search.R
\name{ft_search}
\alias{ft_search}
\alias{ft_search_ls}
\title{Search for full text}
\usage{
ft_search(query, from = "plos", limit = 10, start = 0,
  plosopts = list(), bmcopts = list(), crossrefopts = list(),
  entrezopts = list(), arxivopts = list(), biorxivopts = list(),
  euroopts = list(), scopusopts = list(), maopts = list(), ...)

ft_search_ls()
}
\arguments{
\item{query}{(character) Query terms}

\item{from}{(character) Source to query, one of more of plos, bmc, crossref,
entrez, arxiv, biorxiv, europmc, scopus, or ma}

\item{limit}{(integer) Number of records to return. default: 10}

\item{start}{(integer) Record number to start at. Only used for
'scopus' right now. default: 0}

\item{plosopts}{(list) PLOS options. See \code{\link[rplos:searchplos]{rplos::searchplos()}}}

\item{bmcopts}{(list) BMC options. See \code{\link[=bmc_search]{bmc_search()}}}

\item{crossrefopts}{(list) Crossref options. See \code{\link[rcrossref:cr_works]{rcrossref::cr_works()}}}

\item{entrezopts}{(list) Entrez options. See \code{\link[rentrez:entrez_search]{rentrez::entrez_search()}}}

\item{arxivopts}{(list) arxiv options. See \code{\link[aRxiv:arxiv_search]{aRxiv::arxiv_search()}}}

\item{biorxivopts}{(list) biorxiv options. See \code{\link[=biorxiv_search]{biorxiv_search()}}}

\item{euroopts}{(list) Euro PMC options. See \code{\link[=eupmc_search]{eupmc_search()}}}

\item{scopusopts}{(list) Scopus options. See \code{\link[=scopus_search]{scopus_search()}}}

\item{maopts}{(list) Microsoft Academic options. See
\code{\link[=microsoft_search]{microsoft_search()}}}

\item{...}{ignored right now}
}
\value{
An object of class \code{ft}, and objects of class \code{ft_ind}
within each source. You can access each data source with \code{$}
}
\description{
\code{ft_search} is a one stop shop for searching for articles
across many publishers and repositories. We currently support search for
PLOS via the  \pkg{rplos} package, Crossref via the \pkg{rcrossref}
package, Entrez via the \pkg{rentrez} package, arXiv via the \pkg{aRxiv}
package, and BMC, Biorxiv, EueroPMC, and Scopus via internal helper
functions in this package.

Many publishers content is searchable via Crossref and Entrez - of course
this doesn't mean that we can get full text for those articles. In the
output objects of this function, we attempt to help by indicating what
license is used for articles.
}
\details{
Each of \code{plosopts}, \code{scopusopts}, etc. expect
a named list.

See \strong{Rate Limits} and \strong{Authentication} in
\link{fulltext-package} for rate limiting and authentication information,
respectively
}
\examples{
# List publishers included
ft_search_ls()

\dontrun{
# Plos
(res1 <- ft_search(query='ecology', from='plos'))
res1$plos
ft_search(query='climate change', from='plos', limit=500, 
  plosopts=list(
   fl=c('id','author','eissn','journal','counter_total_all',
   'alm_twitterCount')))

# Crossref
(res2 <- ft_search(query='ecology', from='crossref'))
res2$crossref

# BioRxiv
(res <- ft_search(query='owls', from='biorxiv'))
res$biorxiv

# Entrez
(res <- ft_search(query='ecology', from='entrez'))
res$entrez

# arXiv
(res <- ft_search(query='ecology', from='arxiv'))
res$arxiv

# BMC - can be very slow
(res <- ft_search(query='ecology', from='bmc'))
res$bmc

# Europe PMC
(res <- ft_search(query='ecology', from='europmc'))
res$europmc

# Scopus
(res <- ft_search(query = 'ecology', from = 'scopus', limit = 100,
   scopusopts = list(key = Sys.getenv('ELSEVIER_SCOPUS_KEY'))))
res$scopus
## pagination
(res <- ft_search(query = 'ecology', from = 'scopus', 
   scopusopts = list(key = Sys.getenv('ELSEVIER_SCOPUS_KEY')), limit = 5))
(res <- ft_search(query = 'ecology', from = 'scopus', 
   scopusopts = list(key = Sys.getenv('ELSEVIER_SCOPUS_KEY')), 
   limit = 5, start = 5))
## lots of results
(res <- ft_search(query = "ecology community elk cow", from = 'scopus', 
   limit = 100,
   scopusopts = list(key = Sys.getenv('ELSEVIER_SCOPUS_KEY'))))
res$scopus

# PLOS, Crossref, and arxiv
(res <- ft_search(query='ecology', from=c('plos','crossref','arxiv')))
res$plos
res$arxiv
res$crossref

# Microsoft academic search
key <- Sys.getenv("MICROSOFT_ACADEMIC_KEY")
(res <- ft_search("Y='19'...", from = "microsoft", maopts = list(key = key)))
res$ma
res$ma$data$DOI
}
}
