% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftdoi_cache.R
\name{ftdoi_cache}
\alias{ftdoi_cache}
\title{Caching}
\description{
Manage cached \code{ftdoi} files with \pkg{hoardr}
}
\details{
The dafault cache directory is
\code{paste0(rappdirs::user_cache_dir(), "/R/ftdoi")}, but you can set
your own path using \code{cache_path_set()}

\code{cache_delete} only accepts 1 file name, while
\code{cache_delete_all} doesn't accept any names, but deletes all files.
For deleting many specific files, use \code{cache_delete} in a \code{\link[=lapply]{lapply()}}
type call
}
\section{Useful user functions}{

\itemize{
\item \code{ftdoi_cache$cache_path_get()} get cache path
\item \code{ftdoi_cache$cache_path_set()} set cache path. You can set the
entire path directly via the \code{full_path} arg like
\code{ftdoi_cache$cache_path_set(full_path = "your/path")}
\item \code{ftdoi_cache$list()} returns a character vector of full
path file names
\item \code{ftdoi_cache$files()} returns file objects with metadata
\item \code{ftdoi_cache$details()} returns files with details
\item \code{ftdoi_cache$delete()} delete specific files
\item \code{ftdoi_cache$delete_all()} delete all files, returns nothing
}
}

\examples{
\dontrun{
ftdoi_cache

# list files in cache
ftdoi_cache$list()

# delete certain database files
# ftdoi_cache$delete("file path")
# ftdoi_cache$list()

# delete all files in cache
# ftdoi_cache$delete_all()
# ftdoi_cache$list()
}
}
\seealso{
Other ftdoi: 
\code{\link{ftd_doi}()},
\code{\link{ftd_fetch_patterns}()},
\code{\link{ftd_members}()},
\code{\link{ftd_prefixes}()},
\code{\link{prefix_local}()}
}
\concept{ftdoi}
