% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funDataClass.R
\name{as.multiFunData}
\alias{as.multiFunData}
\alias{as.multiFunData,funData-method}
\title{Coerce a funData object to class multiFunData}
\usage{
as.multiFunData(object)

\S4method{as.multiFunData}{funData}(object)
}
\arguments{
\item{object}{The \code{funData} object that is to be converted to a
\code{multiFunData} object of length 1.}
}
\description{
Coerce a \code{funData} object to class \code{multiFunData} with one element.
}
\examples{
# create funData object with 5 observations
x <- seq(0,1,0.01)
f1 <- funData(argvals = x, X = 1:5 \%o\% x)
f1
class(f1)

# coerce to multiFunData object (of length 1)
m1 <- as.multiFunData(f1)
m1
class(m1)
}
\seealso{
\code{\linkS4class{funData}}, \code{\linkS4class{multiFunData}}
}
