% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce.R
\name{funData2fd}
\alias{funData2fd}
\title{Convert a funData object to fd}
\usage{
funData2fd(object, ...)
}
\arguments{
\item{object}{A \code{funData} object}

\item{...}{Other parameters passed to \code{\link[fda]{Data2fd}}.}
}
\value{
An object of class \code{\link[fda]{fd}}.
}
\description{
This function converts an object of class \code{\link{funData}} to an
object of class \code{\link[fda]{fd}} (from package \pkg{fda}). It
heavily builds on the function \code{\link[fda]{Data2fd}} from the
\pkg{fda} package. The \code{\link[fda]{fd}} representation assumes a
basis representation for the observed functions and therefore
implicitly smoothes the data. In \code{funData} objects, the data is
saved in 'raw' format.
}
\section{Warning}{
 This function works only for funData objects on
  one-dimensional domains.
}

\examples{
# Install / load package fda before running the examples
library("fda")

# from Data2fd help
daybasis <- create.fourier.basis(c(0, 365), nbasis=65)
# funData object with temperature
tempFun <- funData(day.5, t(CanadianWeather$dailyAv[, , "Temperature.C"]))
# convert to fd
tempfd <- funData2fd(tempFun, daybasis)

# plot to compare
par(mfrow = c(1,2))
plot(tempFun, main = "funData object (raw data)")
plot(tempfd, main = "fd object (smoothed)")
}
\seealso{
\code{\linkS4class{funData}}, \code{\link[fda]{fd}},
  \code{\link[fda]{Data2fd}}, \code{\link{fd2funData}}
}
