% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{plus_mfd}
\alias{plus_mfd}
\alias{+.mfd}
\title{Add multivariate functional data}
\usage{
plus_mfd(mfdobj1, mfdobj2)

\method{+}{mfd}(mfdobj1, mfdobj2)
}
\arguments{
\item{mfdobj1, mfdobj2}{Objects of class \code{mfd}. If \code{mfdobj2} is missing,
unary plus is applied.}
}
\value{
An object of class \code{mfd} with coefficients equal to the (possibly
replicated) sum of the inputs. The \code{fdnames} are taken from the input
providing the observation indexing after replication (if any), otherwise
from \code{mfdobj1}.
}
\description{
Adds two objects of class \code{mfd} (elementwise on their coefficient arrays).
The two objects must share the same basis system and number of variables.
If one object contains a single replication (i.e., one observation) and the
other contains multiple, the single replication is replicated across
observations before addition.
}
\details{
If \code{mfdobj2} is missing, the function returns \code{mfdobj1} unchanged
(i.e., unary plus).

Let the coefficient arrays have dimensions \eqn{(nbasis, nobs, nvar)}.
The following checks/rules are enforced:
\itemize{
\item Both inputs must be \code{mfd} objects; otherwise an error is thrown.
\item The basis systems must be identical (checked via \code{identical()}).
\item The number of variables must match.
\item For the number of observations: if both \eqn{nobs_1} and \eqn{nobs_2}
are greater than one, they must be equal; otherwise, the object with
\eqn{nobs = 1} is replicated to match the other.
}
}
\examples{
# Assuming mfdobj_a and mfdobj_b are 'mfd' objects on the same basis:
# mfdobj_a + mfdobj_b
# plus_mfd(mfdobj_a, mfdobj_b)

}
\seealso{
\code{\link{nobs}}, \code{\link{nbasis}}, \code{\link{nvar}}, \code{\link{mfd}}
}
