% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kurt.R
\name{kurt}
\alias{kurt}
\title{Calculate Univariate Kurtosis for a Vector or Matrix}
\usage{
kurt(x)
}
\arguments{
\item{x}{Either a vector or matrix of numeric values.}
}
\value{
\item{Kurtosis for each column in x.}{}
}
\description{
Calculate univariate kurtosis for a vector or matrix (algorithm G2 in Joanes
& Gill, 1998). Note that, as defined in this function, the expected kurtosis of 
a normally distributed variable is 0 (i.e., not 3).
}
\examples{

x <- matrix(rnorm(1000), 100, 10)
print(kurt(x))

}
\references{
Joanes, D. N. & Gill, C. A. (1998). Comparing measures of sample
skewness and kurtosis. \emph{The Statistician, 47}, 183-189.
}
\seealso{
\code{\link{skew}}
}
\author{
Niels Waller
}
\keyword{Statistics}
