% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faBounds.R
\name{faBounds}
\alias{faBounds}
\title{Bounds on the Correlation Between an External Variable and a Common Factor}
\usage{
faBounds(Lambda, RX, rXY, alphaY = 1)
}
\arguments{
\item{Lambda}{(matrix) A p x 1 matrix of factor loadings.}

\item{RX}{(matrix) A p x p matrix of correlations for the factor indicators.}

\item{rXY}{(vector) A p x 1 vector of correlations between the factor
indicators (X) and the external variable (Y).}

\item{alphaY}{(scalar)  The reliability of Y. Default \code{alphaY = 1}.}
}
\value{
\code{faBounds} returns the following objects:
\itemize{
  \item \strong{Lambda} (matrix) A p x 1 vector of factor loadings. 
   \item  \strong{RX} (matrix) The indicator correlation matrix. 
   \item  \strong{rXY}: (vector) The correlations between the factor indicators (X) and the 
   external variable (Y).
   \item \strong{alphaY} (integer) The reliability of the external variable.
   \item \strong{bounds} (vector)  A 2 x 1 vector that includes the lower and upper bounds 
   for the correlation between an external variable and a common factor. 
   \item \strong{rUiY} (vector) Correlations between the unique factors and the 
   external variable for the lower bound estimate.
   \item \strong{rUjY} (vector) Correlations between the unique factors and the 
   external variable for the upper bound estimate.
}
}
\description{
This function computes the  bounds on the correlation between an 
external variable and a common factor.
}
\examples{
## Example 
## We wish to compute the bounds between the Speed factor from the 
## Holzinger (H) and Swineford data and a hypothetical external 
## variable, Y.

## RH = R matrix for *H*olzinger Swineford data
RH <- 
 matrix(c( 1.00,   0,    0,     0,     0,     0,
           .73, 1.00,    0,     0,     0,     0, 
           .70,  .72,  1.00,    0,     0,     0,
           .17,  .10,   .12,  1.00,    0,     0,
           .11,  .14,   .15,   .49,  1.00,    0,
           .21,  .23,   .21,   .34,   .45,  1.00), 6, 6)

RH <- RH + t(RH) - diag(6)
RX <- RH[4:6, 4:6]

## S-C = Straight-curved
 colnames(RX) <- rownames(RX) <-
        c("Addition", "Counting dots", "S-C capitals")
print( RX, digits = 2 ) 

## Extract 1 MLE factor  
fout <- faMain(R = RX, 
              numFactors = 1, 
              facMethod = "faml", 
              rotate="none")

## Lambda = factor loadings matrix  
Lambda <- fout$loadings
print( Lambda, digits = 3 ) 

## rXY = correlations between the factor indicators (X) and
## the external variable (Y)

 rXY = c(.1, .2, .3)
 
 # Assume that the reliability of Y = .75
 
 faBounds(Lambda, RX, rXY, alphaY = .75)
 
}
\references{
Steiger, J. H.  (1979).  The relationship between external 
variables and common factors. Psychometrika, 44, 93-97.

Waller, N. G. (under review). New results on the relationship 
between an external variable and a common factor.
}
\author{
Niels G. Waller
}
