% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multisession.R
\name{multisession}
\alias{multisession}
\title{Create a multisession future whose value will be resolved asynchroneously in a parallel R session}
\usage{
multisession(expr, envir = parent.frame(), substitute = TRUE,
  maxCores = availableCores(), ...)
}
\arguments{
\item{expr}{An R \link[base]{expression}.}

\item{envir}{The \link{environment} in which the evaluation
is done and from which globals are obtained.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{maxCores}{The maximum number of multisession future that
can be active at the same time before blocking.}

\item{\dots}{Not used.}
}
\value{
A \link{MultisessionFuture}.
If \code{maxCores == 1}, then all processing using done in the
current/main R session and we therefore fall back to using
a lazy future.
}
\description{
A multisession future is a future that uses multisession evaluation,
which means that its \emph{value is computed and resolved in
parallel in another R session}.
}
\details{
This function will block if all available R session are occupied
and will be unblocked as soon as one of the already running
multisession futures is resolved.  For the total number of
R sessions available including the current/main R process, see
\code{\link{availableCores}()}.

A multisession future is a special type of cluster future.

The preferred way to create an multisession future is not to call
this function directly, but to register it via
\code{\link{plan}(multisession)} such that it becomes the default
mechanism for all futures.  After this \code{\link{future}()}
and \code{\link{\%<=\%}} will create \emph{multisession futures}.
}
\section{Known issues}{

In the current implementation, \emph{all} background R sessions
are allocated and launched in the background \emph{as soon as the
first multisession future is created}. This means that more R
sessions may be running than what will ever be used.
The reason for this is that background sessions are currently
created using \code{\link[parallel:makeCluster]{makeCluster}()},
which requires that all R sessions are created at once.
}
\examples{
## Multisession futures gives an error on R CMD check on
## Windows (but not Linux or OS X) for unknown reasons.
## The same code works in package tests.
\donttest{

## Use multisession futures
plan(multisession)

## A global variable
a <- 0

## Create multicore future (explicitly)
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## A multisession future is evaluated in a separate R session.
## Changing the value of a global variable will not affect
## the result of the future.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)

}
}
\seealso{
Use \code{\link{availableCores}()} to see the total number of
cores that are available for the current R session.
}

