% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweak_parallel_PSOCK.R
\name{tweak_parallel_PSOCK}
\alias{tweak_parallel_PSOCK}
\title{Tweak PSOCK backend of the parallel package}
\usage{
tweak_parallel_PSOCK(user = TRUE, revtunnel = TRUE, rshopts = TRUE,
  use127.0.0.1 = FALSE, reset = FALSE)
}
\arguments{
\item{user}{If TRUE, parallel is tweaked to only pass username to SSH if it is specified via argument \code{user}.}

\item{revtunnel}{If TRUE, parallel is tweaked to make use of reverse SSH tunneling.}

\item{rshopts}{If TRUE, parallel is tweaked so it is possible to specify additional command-line options to the \code{rshcmd} executable.}

\item{use127.0.0.1}{If TRUE, \code{127.0.0.1} is used instead of \code{localhost}.}

\item{reset}{If TRUE, all tweaks are undone.}
}
\value{
Nothing.
}
\description{
Tweak PSOCK backend of the parallel package
}
\examples{
\donttest{\dontrun{
trace(system, tracer = quote(stop("Command: ", command)), print = FALSE)

## Without tweaks
try(cl <- parallel::makeCluster("remote.myserver.org", revtunnel=TRUE,
                                master="localhost", homogeneous=FALSE))
### Error in eval(expr, envir, enclos) : 
###  Command:
###    ssh
###      -l hb
###      remote.myserver.org
###      "Rscript
###         --default-packages=datasets,utils,grDevices,graphics,stats,methods
###         -e 'parallel:::.slaveRSOCK()' MASTER=localhost PORT=11099
###         OUT=/dev/null TIMEOUT=2592000 XDR=TRUE"

## With tweaks
future:::tweak_parallel_PSOCK()
try(cl <- parallel::makeCluster("remote.myserver.org", revtunnel=TRUE,
                                master="localhost", homogeneous=FALSE))
### Error in eval(expr, envir, enclos) : 
###  Command:
###    ssh
###      -R 11624:localhost:11624
###      remote.myserver.org
###      "Rscript
###         --default-packages=datasets,utils,grDevices,graphics,stats,methods
###         -e 'parallel:::.slaveRSOCK()' MASTER=localhost PORT=11099
###         OUT=/dev/null TIMEOUT=2592000 XDR=TRUE"

## Undo tweaks
untrace(system)
future:::tweak_parallel_PSOCK(reset=TRUE)
}}

}
\references{
\url{https://github.com/HenrikBengtsson/Wishlist-for-R/issues/32}\cr
}
\keyword{internal}

