% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fwb.R
\name{plot.fwb}
\alias{plot.fwb}
\title{Plots of the Output of a Fractional Weighted Bootstrap}
\usage{
\method{plot}{fwb}(
  x,
  index = 1,
  qdist = "norm",
  nclass = NULL,
  df,
  type = c("hist", "qq"),
  ...
)
}
\arguments{
\item{x}{an \code{fwb} object; the output of a call to \code{\link[=fwb]{fwb()}}.}

\item{index}{the index of the position of the quantity of interest in \code{x$t0} if more than one was specified in \code{fwb()}. Only one value is allowed at a time. By default the first statistic is used.}

\item{qdist}{\code{character}; when a Q-Q plot is requested (as it is by default; see \code{type} argument below), the distribution against which the Q-Q plot should be drawn. Allowable options include \code{"norm"} (normal distribution - the default) and \code{"chisq"} (chi-squared distribution).}

\item{nclass}{when a histogram is requested (as it is by default; see \code{type} argument below), the number of classes to be used. The default is the integer between 10 and 100 closest to \code{ceiling(length(R)/25)} where \code{R} is the number of bootstrap replicates.}

\item{df}{if \code{qdist} is \code{"chisq"}, the degrees of freedom for the chi-squared distribution to be used. If not supplied, the degrees of freedom will be estimated using maximum likelihood.}

\item{type}{the type of plot to display. Allowable options include \code{"hist"} for a histogram of the bootstrap estimates and \code{"qq"} for a Q-Q plot of the estimates against the distribution supplied to \code{qdist}.}

\item{...}{ignored.}
}
\value{
\code{x} is returned invisibly.
}
\description{
\code{plot.fwb()} takes an \code{fwb} object and produces plots for the bootstrap replicates of the statistic of interest.
}
\details{
This function can produces two side-by-side plots: a histogram of the bootstrap replicates and a Q-Q plot of the bootstrap replicates against theoretical quantiles of a supplied distribution (normal or chi-squared). For the histogram, a vertical dotted line indicates the position of the estimate computed in the original sample. For the Q-Q plot, the expected line is plotted.
}
\examples{
# See examples at help("fwb")
}
\seealso{
\code{\link[=fwb]{fwb()}}, \code{\link[=summary.fwb]{summary.fwb()}}, \pkgfun{boot}{plot.boot}, \code{\link[=hist]{hist()}}, \code{\link[=qqplot]{qqplot()}}
}
