% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.mboottest}
\alias{print.mboottest}
\title{S3 method to print key information for objects of type \code{mboottest}}
\usage{
\method{print}{mboottest}(x, ..., digits = 4)
}
\arguments{
\item{x}{object of type mboottest}

\item{...}{Further arguments passed to or from other methods.}

\item{digits}{Number of rounding digits}
}
\value{
A scalar containing the effective number of observations used
in \code{mboottest}
}
\description{
S3 method to print key information for objects of type \code{mboottest}
}
\examples{
\dontrun{
requireNamespace("clubSandwich")
R <- clubSandwich::constrain_zero(2:3, coef(lm_fit))
wboottest <-
  mboottest(
    object = lm_fit,
    clustid = "group_id1",
    B = 999,
    R = R
  )
print(wboottest)
}

}
