% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_val_null.R
\name{p_val_null2}
\alias{p_val_null2}
\title{Calculate p-values based on A, B, CC, CD, DD and other inputs}
\usage{
p_val_null2(
  beta0,
  A,
  B,
  CC,
  CD,
  DD,
  clustid,
  boot_iter,
  small_sample_correction,
  impose_null,
  point_estimate,
  p_val_type
)
}
\arguments{
\item{beta0}{Scalar. Shifts the null hypothesis.}

\item{A}{A list.}

\item{B}{A list.}

\item{CC}{A list.}

\item{CD}{A list.}

\item{DD}{A list.}

\item{clustid}{A data.frame containing the cluster variables.}

\item{boot_iter}{An integer. Number of bootstrap iterations.}

\item{small_sample_correction}{A vector of the dimension of ncol(clustid)}

\item{impose_null}{If TRUE, no null hypothesis if imposed on the bootstrap}

\item{point_estimate}{The point estimate of the test parameter from the regression model.}

\item{p_val_type}{type Type of p-value. By default "two-tailed". Other options: "equal-tailed", ">", "<"}
}
\value{
A list containing the bootstrapped p-value, the bootstrapped t-statistics,
and the number of invalid test statistics.
}
\description{
Calculate p-values based on A, B, CC, CD, DD and other inputs
}
