% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boottest_fixest.R
\name{boottest.fixest}
\alias{boottest.fixest}
\title{Fast wild cluster bootstrap inference for object of class fixest}
\usage{
\method{boottest}{fixest}(
  object,
  param,
  B,
  clustid = NULL,
  bootcluster = "max",
  fe = NULL,
  sign_level = 0.05,
  conf_int = TRUE,
  seed = NULL,
  R = NULL,
  r = 0,
  beta0 = NULL,
  type = "rademacher",
  impose_null = TRUE,
  p_val_type = "two-tailed",
  tol = 1e-06,
  maxiter = 10,
  na_omit = TRUE,
  nthreads = getBoottest_nthreads(),
  ssc = boot_ssc(adj = TRUE, fixef.K = "none", cluster.adj = TRUE, cluster.df =
    "conventional"),
  boot_algo = getBoottest_boot_algo(),
  floattype = "Float64",
  maxmatsize = FALSE,
  bootstrapc = FALSE,
  t_boot = FALSE,
  getauxweights = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class fixest and estimated via \code{fixest::feols()}. Non-linear models are not supported.}

\item{param}{A character vector. The name of the regression
coefficient(s) for which the hypothesis is to be tested}

\item{B}{Integer. The number of bootstrap iterations. When the number of clusters is low,
increasing B adds little additional runtime.}

\item{clustid}{A character vector containing the names of the cluster variables. If NULL,
a heteroskedasticity-robust (HC1) wild bootstrap is run.}

\item{bootcluster}{A character vector. Specifies the bootstrap clustering variable or variables. If more
than one variable is specified, then bootstrapping is clustered by the intersections of
clustering implied by the listed variables. To mimic the behavior of stata's boottest command,
the default is to cluster by the intersection of all the variables specified via the \code{clustid} argument,
even though that is not necessarily recommended (see the paper by Roodman et al cited below, section 4.2).
Other options include "min", where bootstrapping is clustered by the cluster variable with the fewest clusters.
Further, the subcluster bootstrap (MacKinnon & Webb, 2018) is supported - see the \code{vignette("fwildclusterboot", package = "fwildclusterboot")} for details.}

\item{fe}{A character vector of length one which contains the name of the fixed effect to be projected
out in the bootstrap. Note: if regression weights are used, fe
needs to be NULL.}

\item{sign_level}{A numeric between 0 and 1 which sets the significance level
of the inference procedure. E.g. sign_level = 0.05
returns 0.95\% confidence intervals. By default, sign_level = 0.05.}

\item{conf_int}{A logical vector. If TRUE, boottest computes confidence
intervals by test inversion. If FALSE, only the p-value is returned.}

\item{seed}{An integer. Allows to set a random seed. For details, see below.}

\item{R}{Hypothesis Vector giving linear combinations of coefficients. Must be either NULL or a vector of the same length as \code{param}. If NULL, a vector of ones of length param.}

\item{r}{A numeric. Shifts the null hypothesis
H0: param = r vs H1: param != r}

\item{beta0}{Deprecated function argument. Replaced by function argument 'r'.}

\item{type}{character or function. The character string specifies the type
of boostrap to use: One of "rademacher", "mammen", "norm"
and "webb". Alternatively, type can be a function(n) for drawing
wild bootstrap factors. "rademacher" by default.
For the Rademacher distribution, if the number of replications B exceeds
the number of possible draw ombinations, 2^(#number of clusters), then \code{boottest()}
will use each possible combination once (enumeration).}

\item{impose_null}{Logical. Controls if the null hypothesis is imposed on
the bootstrap dgp or not. Null imposed \code{(WCR)} by default.
If FALSE, the null is not imposed \code{(WCU)}}

\item{p_val_type}{Character vector of length 1. Type of p-value.
By default "two-tailed". Other options include "equal-tailed", ">" and "<".}

\item{tol}{Numeric vector of length 1. The desired accuracy
(convergence tolerance) used in the root finding procedure to find the confidence interval.
1e-6 by default.}

\item{maxiter}{Integer. Maximum number of iterations used in the root finding procedure to find the confidence interval.
10 by default.}

\item{na_omit}{Logical. If TRUE, \code{boottest()} omits rows with missing
variables in the cluster variable that have not previously been deleted
when fitting the regression object (e.g. if the cluster variable was not used
when fitting the regression model).}

\item{nthreads}{The number of threads. Can be: a) an integer lower than,
or equal to, the maximum number of threads; b) 0: meaning
all available threads will be used; c) a number strictly
between 0 and 1 which represents the fraction of all threads
to use. The default is to use 1 core.}

\item{ssc}{An object of class \code{boot_ssc.type} obtained with the function \code{\link[fwildclusterboot]{boot_ssc}}. Represents how the small sample adjustments are computed. The defaults are \verb{adj = TRUE, fixef.K = "none", cluster.adj = "TRUE", cluster.df = "conventional"}.
You can find more details in the help file for \code{boot_ssc()}. The function is purposefully designed to mimic fixest's \code{\link[fixest]{ssc}} function.}

\item{boot_algo}{Character scalar. Either "R" or "WildBootTests.jl". Controls the algorithm employed by boottest().
"R" is the default and implements the cluster bootstrap as in Roodman (2019). "WildBootTests.jl" executes the wild cluster bootstrap via the WildBootTests.jl
package. For it to run, Julia and WildBootTests.jl need to be installed.
Note that if no cluster is provided, boottest() always defaults to the "lean" algorithm. You can set the employed algorithm globally by using the
\code{setBoottest_boot_algo()} function.}

\item{floattype}{Float64 by default. Other option: Float32. Should floating point numbers in Julia be represented as 32 or 64 bit? Only relevant when 'boot_algo = "WildBootTests.jl"'}

\item{maxmatsize}{NULL by default = no limit. Else numeric scalar to set the maximum size of auxilliary weight matrix (v), in gigabytes. Only relevant when 'boot_algo = "WildBootTests.jl"'}

\item{bootstrapc}{Logical scalar, FALSE by default. TRUE  to request bootstrap-c instead of bootstrap-t. Only relevant when 'boot_algo = "WildBootTests.jl"'}

\item{t_boot}{Logical. Should bootstrapped t-statistics be returned?}

\item{getauxweights}{Logical. Whether to save auxilliary weight matrix (v)}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An object of class \code{boottest}

\item{p_val}{The bootstrap p-value.}
\item{conf_int}{The bootstrap confidence interval.}
\item{param}{The tested parameter.}
\item{N}{Sample size. Might differ from the regression sample size if
the cluster variables contain NA values.}
\item{boot_iter}{Number of Bootstrap Iterations.}
\item{clustid}{Names of the cluster Variables.}
\item{N_G}{Dimension of the cluster variables as used in boottest.}
\item{sign_level}{Significance level used in boottest.}
\item{type}{Distribution of the bootstrap weights.}
\item{impose_null}{Whether the null was imposed on the bootstrap dgp or not.}
\item{R}{The vector "R" in the null hypothesis of interest Rbeta = r.}
\item{r}{The scalar "r" in the null hypothesis of interest Rbeta = r.}
\item{point_estimate}{R'beta. A scalar: the constraints vector times the regression coefficients.}
\item{grid_vals}{All t-statistics calculated while calculating the
confidence interval.}
\item{p_grid_vals}{All p-values calculated while calculating the confidence
interval.}
\item{t_stat}{The 'original' regression test statistics.}
\item{t_boot}{All bootstrap t-statistics.}
\item{regression}{The regression object used in boottest.}
\item{call}{Function call of boottest.}
\item{boot_algo}{The employed bootstrap algorithm.}
\item{nthreads}{The number of threads employed.}
\item{internal_seed}{The integer value -inherited from set.seed() - used within boottest() to set the random seed in either R or Julia. If NULL, no internal seed was created.}
}
\description{
\code{boottest.fixest} is a S3 method that allows for fast wild cluster
bootstrap inference for objects of class fixest by  implementing
the fast wild bootstrap algorithm developed in Roodman et al., 2019 and
implemented in the STATA package \code{boottest}.
}
\section{Setting Seeds}{

To guarantee reproducibility, you can either use \verb{boottest()'s} \code{seed} function argument, or
set a global random seed via
\itemize{
\item \code{set.seed()} when using
\enumerate{
\item the lean algorithm (via \code{boot_algo = "R-lean"}), 2) the heteroskedastic wild bootstrap
\item the wild cluster bootstrap via \code{boot_algo = "R"} with Mammen weights or 4) \code{boot_algo = "WildBootTests.jl"}
}
\item \code{dqrng::dqset.seed()} when using \code{boot_algo = "R"} for Rademacher, Webb or Normal weights
}
}

\section{Confidence Intervals}{

\code{boottest} computes confidence intervals by inverting p-values.
In practice, the following procedure is used:
\itemize{
\item Based on an initial guess for starting values, calculate p-values
for 26 equal spaced points between the starting values.
\item Out of the 26 calculated p-values, find the two pairs of values x
for which the corresponding p-values px cross the significance
sign_level sign_level.
\item Feed the two pairs of x into an numerical root finding procedure
and solve for the root. boottest currently relies on
\code{stats::uniroot} and sets an absolute tolerance of 1e-06 and
stops the procedure after 10 iterations.
}
}

\section{Standard Errors}{

\code{boottest} does not calculate standard errors.
}

\examples{
\dontrun{
if (requireNamespace("fixest")) {
  library(fwildclusterboot)
  library(fixest)
  data(voters)
  feols_fit <- feols(proposition_vote ~ treatment + ideology1 + log_income,
    fixef = "Q1_immigration",
    data = voters
  )
  boot1 <- boottest(feols_fit,
    B = 9999,
    param = "treatment",
    clustid = "group_id1"
  )
  boot2 <- boottest(feols_fit,
    B = 9999,
    param = "treatment",
    clustid = c("group_id1", "group_id2")
  )
  boot3 <- boottest(feols_fit,
    B = 9999,
    param = "treatment",
    clustid = c("group_id1", "group_id2"),
    fe = "Q1_immigration"
  )
  boot4 <- boottest(feols_fit,
    B = 9999,
    param = "treatment",
    clustid = c("group_id1", "group_id2"),
    fe = "Q1_immigration",
    sign_level = 0.2,
    seed = 8,
    r = 2
  )
  # test treatment + ideology1 = 2
  boot5 <- boottest(feols_fit,
    B = 9999,
    clustid = c("group_id1", "group_id2"),
    param = c("treatment", "ideology1"),
    R = c(1, 1),
    r = 2
  )
  summary(boot1)
  plot(boot1)
}
}

}
\references{
Roodman et al., 2019, "Fast and wild: Bootstrap inference in
STATA using boottest", The STATA Journal.
(\url{https://journals.sagepub.com/doi/full/10.1177/1536867X19830877})

Cameron, A. Colin, Jonah B. Gelbach, and Douglas L. Miller. "Bootstrap-based improvements for inference with clustered errors." The Review of Economics and Statistics 90.3 (2008): 414-427.

MacKinnon, James G., and Matthew D. Webb. "The wild bootstrap for few (treated) clusters." The Econometrics Journal 21.2 (2018): 114-135.

MacKinnon, James. "Wild cluster bootstrap confidence intervals." L'Actualite economique 91.1-2 (2015): 11-33.

Webb, Matthew D. Reworking wild bootstrap based inference for clustered errors. No. 1315. Queen's Economics Department Working Paper, 2013.
}
