/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.filechooser.FileFilter;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.widgets.DesktopPaneBG;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.datatable.DataTable;
import org.af.gMCP.gui.dialogs.AdjustedPValueDialog;
import org.af.gMCP.gui.dialogs.DialogConfIntEstVar;
import org.af.gMCP.gui.dialogs.RejectedDialog;
import org.af.gMCP.gui.dialogs.VariableNameDialog;
import org.af.gMCP.gui.graph.DView;
import org.af.gMCP.gui.graph.Edge;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.NetList;
import org.af.gMCP.gui.graph.PView;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingworker.SwingWorker;
import org.mutoss.gui.TransferableImage;

public class GraphView
extends JPanel
implements ActionListener {
    String name;
    CreateGraphGUI parent;
    public static final String STATUSBAR_DEFAULT = "Place new nodes and edges or start the test procedure";
    JLabel statusBar;
    public NetList nl;
    JToggleButton buttonNewVertex;
    JButton buttonNewEdge;
    JButton buttonZoomOut;
    JButton buttonZoomIn;
    JButton buttonadjPval;
    JButton buttonConfInt;
    JButton buttonStart;
    JButton buttonBack;
    String correlation = "";
    public String result = ".gMCPResult_" + new Date().getTime();
    protected boolean resultUpToDate = false;
    private static final Log logger = LogFactory.getLog(GraphView.class);

    public String getGraphName() {
        return this.name;
    }

    public CreateGraphGUI getMainFrame() {
        return this.parent;
    }

    public PView getPView() {
        return this.parent.getPView();
    }

    public void updateEdge(int from, int to, Double w) {
        this.updateEdge(from, to, new EdgeWeight(w));
    }

    public DataTable getDataTable() {
        return this.parent.getDataTable();
    }

    public CreateGraphGUI getGraphGUI() {
        return this.parent;
    }

    public GraphView(String graph, CreateGraphGUI createGraphGUI) {
        this.name = graph;
        this.parent = createGraphGUI;
        this.statusBar = new JLabel(STATUSBAR_DEFAULT);
        this.nl = new NetList(this.statusBar, this);
        this.setLayout(new BorderLayout());
        this.add("North", this.getNorthPanel());
        JScrollPane sPane = new JScrollPane(this.nl);
        this.add("Center", sPane);
    }

    public void setGraphName(String name) {
        this.name = name;
    }

    public JPanel getNorthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", this.getToolBar());
        panel.add("South", this.statusBar);
        return panel;
    }

    public JPanel getToolBar() {
        JPanel toolPanel = new JPanel();
        try {
            toolPanel.setLayout(new FlowLayout());
            ((FlowLayout)toolPanel.getLayout()).setAlignment(0);
            this.buttonNewVertex = new JToggleButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/vertex.png"))));
            toolPanel.add(this.buttonNewVertex);
            this.buttonNewVertex.addActionListener(this);
            this.buttonNewVertex.setToolTipText("new vertex");
            this.buttonNewEdge = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/edge.png"))));
            toolPanel.add(this.buttonNewEdge);
            this.buttonNewEdge.addActionListener(this);
            this.buttonNewEdge.setToolTipText("new edge");
            this.buttonZoomOut = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/zoom_out.png"))));
            toolPanel.add(this.buttonZoomOut);
            this.buttonZoomOut.addActionListener(this);
            this.buttonZoomOut.setToolTipText("zoom out");
            this.buttonZoomIn = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/zoom_in.png"))));
            toolPanel.add(this.buttonZoomIn);
            this.buttonZoomIn.addActionListener(this);
            this.buttonZoomIn.setToolTipText("zoom in");
            this.buttonStart = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/StartTesting.png"))));
            toolPanel.add(this.buttonStart);
            this.buttonStart.addActionListener(this);
            this.buttonStart.setEnabled(false);
            this.buttonStart.setToolTipText("start testing");
            this.buttonadjPval = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/adjPval.png"))));
            toolPanel.add(this.buttonadjPval);
            this.buttonadjPval.addActionListener(this);
            this.buttonadjPval.setEnabled(false);
            this.buttonadjPval.setToolTipText("calculate adjusted p-values");
            this.buttonConfInt = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/confint2.png"))));
            toolPanel.add(this.buttonConfInt);
            this.buttonConfInt.addActionListener(this);
            this.buttonConfInt.setEnabled(false);
            this.buttonConfInt.setToolTipText("calculate confidence intervals");
        }
        catch (IOException e) {
            ErrorHandler.getInstance().makeErrDialog(e.getMessage(), (Object)e);
        }
        return toolPanel;
    }

    public NetList getNL() {
        return this.nl;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.buttonZoomIn)) {
            this.nl.setZoom(this.nl.getZoom() * 1.25);
            this.getNL().refresh();
        } else if (e.getSource().equals(this.buttonZoomOut)) {
            this.nl.setZoom(this.nl.getZoom() / 1.25);
            this.getNL().refresh();
        } else if (e.getSource().equals(this.buttonNewEdge)) {
            this.nl.newVertex = false;
            this.buttonNewVertex.setSelected(false);
            this.nl.newEdge = true;
            this.getNL().statusBar.setText("Select a node from which this edge should start.");
        } else if (e.getSource().equals(this.buttonNewVertex)) {
            if (this.buttonNewVertex.isSelected()) {
                this.nl.newVertex = true;
                this.nl.newEdge = false;
                this.nl.arrowHeadPoint = null;
                this.nl.firstVertexSelected = false;
            } else {
                this.nl.newVertex = false;
            }
            this.nl.repaint();
            this.getNL().statusBar.setText("Click on the graph panel to place the node.");
        } else if (e.getSource().equals(this.buttonConfInt)) {
            if (!this.getNL().isTesting()) {
                this.getPView().savePValues();
                this.getNL().saveGraphWithoutVariables(this.getNL().initialGraph, false);
                this.getNL().loadGraph();
                this.getPView().restorePValues();
            }
            if (this.getNL().getNodes().size() == 0) {
                JOptionPane.showMessageDialog(this.parent, "Please create first a graph.", "Please create first a graph.", 0);
            } else {
                this.parent.glassPane.start();
                this.correlation = this.parent.getPView().getParameters();
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    protected Void doInBackground() throws Exception {
                        if (!GraphView.this.isResultUpToDate()) {
                            RControl.getR().evalVoid(GraphView.this.result + " <- gMCP(" + GraphView.this.getNL().initialGraph + GraphView.this.getGMCPOptions() + ")");
                            GraphView.this.setResultUpToDate(true);
                        }
                        double[] alpha = RControl.getR().eval("" + GraphView.this.getPView().getTotalAlpha() + "*getWeights(" + GraphView.this.result + ")").asRNumeric().getData();
                        boolean[] rejected = RControl.getR().eval("getRejected(" + GraphView.this.result + ")").asRLogical().getData();
                        GraphView.this.parent.glassPane.stop();
                        new DialogConfIntEstVar(GraphView.this.parent, GraphView.this.nl, rejected, alpha);
                        return null;
                    }
                };
                worker.execute();
            }
        } else if (e.getSource().equals(this.buttonStart)) {
            if (!this.getNL().isTesting()) {
                this.getPView().savePValues();
                this.getNL().saveGraphWithoutVariables(this.getNL().initialGraph, false);
                this.getNL().loadGraph();
                this.getPView().restorePValues();
                this.parent.glassPane.start();
                this.startTesting();
                this.correlation = this.parent.getPView().getParameters();
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    protected Void doInBackground() throws Exception {
                        if (!GraphView.this.isResultUpToDate()) {
                            RControl.getR().evalVoid(GraphView.this.result + " <- gMCP(" + GraphView.this.getNL().initialGraph + GraphView.this.getGMCPOptions() + ")");
                            GraphView.this.setResultUpToDate(true);
                        }
                        boolean[] rejected = RControl.getR().eval(GraphView.this.result + "@rejected").asRLogical().getData();
                        String output = null;
                        if (Configuration.getInstance().getGeneralConfig().verbose() && RControl.getR().eval("!is.null(attr(" + GraphView.this.result + ", \"output\"))").asRLogical().getData()[0]) {
                            output = RControl.getR().eval("attr(" + GraphView.this.result + ", \"output\")").asRChar().getData()[0];
                        }
                        GraphView.this.parent.glassPane.stop();
                        new RejectedDialog(GraphView.this.parent, rejected, GraphView.this.parent.getGraphView().getNL().getNodes(), output);
                        return null;
                    }
                };
                worker.execute();
            } else {
                this.stopTesting();
            }
        } else if (e.getSource().equals(this.buttonadjPval)) {
            if (this.getNL().getNodes().size() == 0) {
                JOptionPane.showMessageDialog(this.parent, "Please create first a graph.", "Please create first a graph.", 0);
            } else {
                if (!this.getNL().isTesting()) {
                    this.getPView().savePValues();
                    this.getNL().saveGraphWithoutVariables(this.getNL().initialGraph, false);
                    this.getNL().loadGraph();
                    this.getPView().restorePValues();
                }
                this.parent.glassPane.start();
                this.correlation = this.parent.getPView().getParameters();
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    protected Void doInBackground() throws Exception {
                        if (!GraphView.this.isResultUpToDate()) {
                            RControl.getR().evalVoid(GraphView.this.result + " <- gMCP(" + GraphView.this.getNL().initialGraph + GraphView.this.getGMCPOptions() + ")");
                            GraphView.this.setResultUpToDate(true);
                        }
                        double[] adjPValues = RControl.getR().eval(GraphView.this.result + "@adjPValues").asRNumeric().getData();
                        GraphView.this.parent.glassPane.stop();
                        new AdjustedPValueDialog(GraphView.this.parent, GraphView.this.getPView().pValues, adjPValues, GraphView.this.getNL().getNodes());
                        return null;
                    }
                };
                worker.execute();
            }
        }
    }

    public void stopTesting() {
        if (!this.getNL().testingStarted) {
            return;
        }
        this.getNL().stopTesting();
        this.getNL().reset();
        this.getNL().loadGraph();
        this.getDataTable().setTesting(false);
        this.getPView().restorePValues();
        this.getPView().setTesting(false);
        this.getPView().revalidate();
        this.getPView().repaint();
        this.buttonNewVertex.setEnabled(true);
        this.buttonNewEdge.setEnabled(true);
        try {
            this.buttonStart.setIcon(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/StartTesting.png"))));
        }
        catch (IOException ex) {
            ErrorHandler.getInstance().makeErrDialog(ex.getMessage(), (Object)ex);
        }
    }

    public void startTesting() {
        if (this.getNL().testingStarted || !this.getPView().jrbNoCorrelation.isSelected()) {
            return;
        }
        this.getPView().savePValues();
        try {
            this.getNL().startTesting();
            this.getNL().saveGraph();
            this.getDataTable().setTesting(true);
            this.getPView().setTesting(true);
            this.buttonNewVertex.setEnabled(false);
            this.buttonNewEdge.setEnabled(false);
            this.buttonStart.setIcon(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/Reset.png"))));
        }
        catch (Exception ex) {
            ErrorHandler.getInstance().makeErrDialog(ex.getMessage(), (Object)ex);
        }
    }

    public void WriteLaTeXwithR() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(this.getMainFrame());
        if (returnVal != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        String filename = file.getAbsolutePath();
        this.nl.saveGraph(".exportGraphToLaTeX", false);
        RControl.getR().eval("gMCPReport(.exportGraphToLaTeX, file=\"" + filename + "\")");
    }

    public void updateEdge(int from, int to, EdgeWeight weight) {
        logger.info((Object)("Adding Edge from " + from + " to " + to + " with weight " + weight.toString() + "."));
        Edge e = this.getNL().findEdge(this.getNL().getNodes().get(from), this.getNL().getNodes().get(to));
        if (e != null) {
            int x = e.getK1();
            int y = e.getK2();
            if (!weight.toString().equals("0")) {
                this.getNL().setEdge(new Edge(this.getNL().getNodes().get(from), this.getNL().getNodes().get(to), weight, this.getNL(), x, y));
            } else {
                this.getNL().removeEdge(e);
            }
        } else {
            this.getNL().setEdge(this.getNL().getNodes().get(from), this.getNL().getNodes().get(to), weight);
        }
        this.getNL().repaint();
    }

    public void enableButtons(Boolean enabled) {
        this.buttonadjPval.setEnabled(enabled);
        if (this.getPView().jrbNoCorrelation.isSelected()) {
            this.buttonConfInt.setEnabled(enabled);
        }
        this.buttonStart.setEnabled(enabled);
    }

    public String getGMCPOptions() {
        return "," + this.getPView().getPValuesString() + this.correlation + ", alpha=" + this.getPView().getTotalAlpha() + ", eps=" + Configuration.getInstance().getGeneralConfig().getEpsilon() + ", verbose=" + (Configuration.getInstance().getGeneralConfig().verbose() ? "42" : "FALSE");
    }

    public DView getDView() {
        return this.parent.getDView();
    }

    public void saveGraphImage(File file) {
        BufferedImage img = this.getNL().getImage();
        try {
            ImageIO.write((RenderedImage)img, "png", file);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Saving image to '" + file.getAbsolutePath() + "' failed: " + ex.getMessage(), "Saving failed.", 0);
        }
    }

    public void saveGraph() {
        JFileChooser fc = new JFileChooser(Configuration.getInstance().getClassProperty(this.getClass(), "RObjDirectory"));
        fc.setFileSelectionMode(0);
        fc.setDialogType(1);
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(".rdata");
            }

            public String getDescription() {
                return "RData files";
            }
        });
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            Configuration.getInstance().setClassProperty(this.getClass(), "RObjDirectory", f.getParent());
            if (!f.getName().toLowerCase().endsWith(".rdata")) {
                f = new File(f.getAbsolutePath() + ".RData");
            }
            try {
                VariableNameDialog vnd = new VariableNameDialog(this.getGraphGUI(), this.getGraphName());
                String name = vnd.getName();
                name = this.getNL().saveGraph(name, false);
                String filename = f.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\");
                RControl.getR().eval("save(" + name + ", file=\"" + filename + "\")");
                JOptionPane.showMessageDialog(this.getMainFrame(), "Exported graph to R object '" + name + "' and saved this to \n'" + f.getAbsolutePath() + "'.", "Saved graph", 1);
                Configuration.getInstance().getGeneralConfig().addGraph(f.getAbsolutePath());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.getMainFrame(), "Saving graph to '" + f.getAbsolutePath() + "' failed: " + ex.getMessage(), "Saving failed", 0);
            }
        }
    }

    public void loadPValuesFromR() {
        VariableNameDialog vnd = new VariableNameDialog(this.getGraphGUI());
        try {
            double[] data = RControl.getR().eval(vnd.getName()).asRNumeric().getData();
            if (data.length != this.getNL().getNodes().size()) {
                JOptionPane.showMessageDialog(this.getMainFrame(), "Number of hypotheses and values do not match.", "Number of hypotheses and values do not match", 0);
                return;
            }
            this.getPView().setPValues(ArrayUtils.toObject((double[])data));
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error loading values from R:\n" + ex.getMessage(), "Error loading values from R", 0);
        }
    }

    public void copyGraphToClipboard() {
        TransferableImage.copyImageToClipboard(this.getNL().getImage());
    }

    public boolean isResultUpToDate() {
        return this.resultUpToDate;
    }

    public void setResultUpToDate(boolean resultUpToDate) {
        this.resultUpToDate = resultUpToDate;
    }
}

