/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.poi;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.graph.GraphView;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.Borders;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphDocXWriter {
    GraphView control;
    static final double zoom = 4.0;

    public GraphDocXWriter(GraphView control) {
        this.control = control;
    }

    public static void addImage(XWPFParagraph p, BufferedImage image) throws IOException, InvalidFormatException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", os);
        ByteArrayInputStream picIS = new ByteArrayInputStream(os.toByteArray());
        XWPFRun run = p.createRun();
        run.addPicture(picIS, 6, "graph.png", Units.toEMU((double)((double)image.getWidth() / 4.0)), Units.toEMU((double)((double)image.getHeight() / 4.0)));
    }

    public void createDocXReport(File file) throws IOException, InvalidFormatException {
        XWPFRun run;
        XWPFDocument doc = new XWPFDocument();
        this.createHeader(doc);
        XWPFParagraph p = doc.createParagraph();
        GraphDocXWriter.addImage(p, this.control.getNL().getImage(4.0));
        doc.createParagraph().createRun().addBreak();
        p = doc.createParagraph();
        String descr = this.control.getDView().getDescription();
        for (String s : descr.split("\\\\n")) {
            run = p.createRun();
            run.setText(s);
            run.addBreak();
        }
        doc.createParagraph().createRun().addBreak();
        p = doc.createParagraph();
        run = p.createRun();
        run.setBold(true);
        run.setText("R Code:");
        run.addBreak();
        run = p.createRun();
        run.setFontSize(10);
        run.setFontFamily("Courier");
        run.setText(this.control.rCode);
        doc.createParagraph().createRun().addBreak();
        List<Double> pv = this.control.getPView().getPValues();
        List<String> pvn = this.control.getNL().nlp.get(0).getHNames();
        boolean[] rejected = null;
        double[] adjPValues = null;
        try {
            rejected = RControl.getR().eval(this.control.result + "@rejected").asRLogical().getData();
            adjPValues = RControl.getR().eval(this.control.result + "@adjPValues").asRNumeric().getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.createPValueTable(doc, pv, pvn, adjPValues, rejected);
        FileOutputStream fos = new FileOutputStream(file);
        doc.write((OutputStream)fos);
        fos.close();
    }

    private void createHeader(XWPFDocument doc) {
        XWPFParagraph p = doc.createParagraph();
        p.setAlignment(ParagraphAlignment.LEFT);
        GraphDocXWriter.setAllBorders(p, Borders.SINGLE);
        XWPFRun run = p.createRun();
        run.setFontSize(24);
        run.setBold(true);
        run.setText("gMCP Report");
        String user = Configuration.getInstance().getGeneralConfig().getUser();
        String rVersion = Configuration.getInstance().getGeneralConfig().getRVersionNumber();
        String gMCPVersion = Configuration.getInstance().getGeneralConfig().getVersionNumber();
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date());
        doc.createParagraph().createRun().setText("Date: " + date + ", User: " + user + ", R " + rVersion + ", gMCP " + gMCPVersion);
        doc.createParagraph().createRun().addBreak();
    }

    private void createPValueTable(XWPFDocument doc, List<Double> pv, List<String> pvn, double[] adjPValues, boolean[] rejected) {
        XWPFTable table = doc.createTable();
        XWPFTableRow row = table.getRow(0);
        row.addNewTableCell();
        XWPFParagraph p = (XWPFParagraph)row.getCell(0).getParagraphs().get(0);
        XWPFRun run = p.createRun();
        run.setText("Hypothesis");
        run.setBold(true);
        p = (XWPFParagraph)row.getCell(1).getParagraphs().get(0);
        run = p.createRun();
        run.setText("P-Value");
        run.setBold(true);
        if (rejected != null) {
            row.addNewTableCell();
            p = (XWPFParagraph)row.getCell(2).getParagraphs().get(0);
            run = p.createRun();
            run.setText("Rejected");
            run.setBold(true);
            if (adjPValues != null) {
                row.addNewTableCell();
                p = (XWPFParagraph)row.getCell(3).getParagraphs().get(0);
                run = p.createRun();
                run.setText("Adj. P-Value");
                run.setBold(true);
            }
        }
        row = table.createRow();
        for (int i = 0; i < pv.size(); ++i) {
            row.getCell(0).setText(pvn.get(i));
            row.getCell(1).setText("" + pv.get(i));
            if (rejected != null) {
                row.getCell(2).setText("" + rejected[i]);
                if (adjPValues != null) {
                    row.getCell(3).setText("" + adjPValues[i]);
                }
            }
            if (i == pv.size() - 1) continue;
            row = table.createRow();
        }
    }

    private static void setAllBorders(XWPFParagraph p, Borders type) {
        p.setBorderBottom(type);
        p.setBorderTop(type);
        p.setBorderRight(type);
        p.setBorderLeft(type);
        p.setBorderBetween(type);
    }
}

