% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPT-POT-compile.R
\name{compile-cpt}
\alias{compile-cpt}
\alias{compileCPT}
\alias{compilePOT}
\alias{print.CPTspec}
\alias{summary.CPTspec}
\title{Compile conditional probability tables / cliques potentials.}
\usage{
compileCPT(x, forceCheck = TRUE, details = 0)

compilePOT(x)
}
\arguments{
\item{x}{To \code{compileCPT} x is a list of conditional
probability tables; to \code{compilePOT}, x is a list of clique
potentials}

\item{forceCheck}{Controls if consistency checks of the probability
tables should be made.}

\item{details}{Controls amount of print out. Mainly for debugging
purposes}
}
\value{
\code{compileCPT} returns a list of class 'cptspec'
    \code{compilePOT} returns a list of class 'potspec'
}
\description{
Compile conditional probability tables / cliques
    potentials as a preprocessing step for creating a graphical
    independence network
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\references{
Søren Højsgaard (2012). Graphical Independence Networks
    with the gRain Package for R. Journal of Statistical Software,
    46(10), 1-26.  \url{http://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{extractCPT}}, \code{\link{extractPOT}}
}
\keyword{utilities}

