% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-moralize.R
\name{graph-moralize}
\alias{graph-moralize}
\alias{moralize}
\alias{moralize.default}
\alias{moralizeMAT}
\title{Moralize a directed acyclic graph}
\usage{
moralize(object, ...)

\method{moralize}{default}(object, result = NULL, ...)
}
\arguments{
\item{object}{A directed acyclic graph represented either as a
\code{graphNEL} object, an \code{igraph}, a (dense)
\code{matrix}, a (sparse) \code{dgCMatrix}.}

\item{\dots}{Additional arguments, currently not used}

\item{result}{The representation of the moralized graph.  When NULL
the representation will be the same as the input object.}
}
\value{
A moralized graph represented either as a \code{graphNEL}, a
    dense \code{matrix} or a sparse \code{dgCMatrix}.
}
\description{
Moralize a directed acyclic graph which means marrying
    parents and dropping directions.
}
\note{
The workhorse is the \code{moralizeMAT} function.
}
\examples{

daG <- dag(~me+ve,~me+al,~ve+al,~al+an,~al+st,~an+st)
moralize(daG)

daG <- dag(~me+ve,~me+al,~ve+al,~al+an,~al+st,~an+st, result="matrix")
moralizeMAT(daG)

if (require(igraph)){
M <- matrix(c(1,2,3,3), nrow=2)
G <- graph.edgelist(M)
G
V(G)$name
moralize(G)
}

}
\seealso{
\code{\link{mcs}}, \code{\link{junction_tree}}, \code{\link{rip}},
    \code{\link{ug}}, \code{\link{dag}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
