#ifndef migrationareaptrvector_h
#define migrationareaptrvector_h

class MigrationArea;

/**
 * \class MigrationAreaPtrVector
 * \brief This class implements a dynamic vector of MigrationArea values
 */
class MigrationAreaPtrVector {
public:
  /**
   * \brief This is the default MigrationAreaPtrVector constructor
   */
  MigrationAreaPtrVector() { size = 0; v = 0; };
  /**
   * \brief This is the MigrationAreaPtrVector constructor that creates a copy of an existing MigrationAreaPtrVector
   * \param initial is the MigrationAreaPtrVector to copy
   */
  MigrationAreaPtrVector(const MigrationAreaPtrVector& initial);
  /**
   * \brief This is the MigrationAreaPtrVector destructor
   * \note This will free all the memory allocated to all the elements of the vector
   */
  ~MigrationAreaPtrVector();
  /**
   * \brief This will add one new entry to the vector
   * \param value is the value that will be entered for the new entry
   */
  void resize(MigrationArea* value);
  /**
   * \brief This will delete an entry from the vector
   * \param pos is the element of the vector to be deleted
   * \note This will free the memory allocated to the deleted element of the vector
   */
  void Delete(int pos);
  /**
   * \brief This will return the size of the vector
   * \return the size of the vector
   */
  int Size() const { return size; };
  /**
   * \brief This will return the value of an element of the vector
   * \param pos is the element of the vector to be returned
   * \return the value of the specified element
   */
  MigrationArea*& operator [] (int pos) { return v[pos]; };
  /**
   * \brief This will return the value of an element of the vector
   * \param pos is the element of the vector to be returned
   * \return the value of the specified element
   */
  MigrationArea* const& operator [] (int pos) const { return v[pos]; };
protected:
  /**
   * \brief This is the vector of MigrationArea values
   */
  MigrationArea** v;
  /**
   * \brief This is the size of the vector
   */
  int size;
};

#endif
