\name{action_predate}
\alias{g3a_predate_catchability_totalfleet}
\alias{g3a_predate_catchability_numberfleet}
\alias{g3a_predate_catchability_linearfleet}
\alias{g3a_predate_catchability_effortfleet}
\alias{g3a_predate_catchability_quotafleet}
\alias{g3a_predate_fleet}
\alias{g3a_predate_totalfleet}
\concept{G3 action}

\title{Gadget3 predation actions}
\description{
  Add predation to a g3 model
}

\usage{
g3a_predate_catchability_totalfleet(E)

g3a_predate_catchability_numberfleet(E)

g3a_predate_catchability_linearfleet(E)

g3a_predate_catchability_effortfleet(catchability_fs, E)

g3a_predate_catchability_quotafleet(quota_table, E,
                                    sum_stocks = list(),
                                    recalc_f = NULL)

g3a_predate_fleet(fleet_stock, prey_stocks, suitabilities, catchability_f,
    overconsumption_f = quote(
        logspace_add_vec(stock__consratio * -1e3, 0.95 * -1e3) / -1e3 ),
    run_f = ~TRUE, run_at = g3_action_order$predate)

# NB: Deprecated interface, use g3a_predate_fleet with g3a_predate_catchability_totalfleet
g3a_predate_totalfleet(fleet_stock, prey_stocks, suitabilities, amount_f,
    overconsumption_f = quote(
        logspace_add_vec(stock__consratio * -1e3, 0.95 * -1e3) / -1e3 ),
    run_f = ~TRUE, run_at = g3_action_order$predate)
}

\arguments{
  \item{fleet_stock}{
    \code{\link{g3_stock}} that describes the harvesting fleet.
  }
  \item{prey_stocks}{
    List of \code{\link{g3_stock}}s that maturing \var{stock} should move into.
  }
  \item{suitabilities}{
    Either a list of stock names to \link{formula} objects, with an optional unnamed
    default option, or a \link{formula} object (which is always used).

    Each \link{formula} should define suitability of a stock, for example
    by using \code{\link{g3_suitability_exponentiall50}}.
  }
  \item{catchability_f}{
    A \link{formula} generated by one of the \code{g3a_predate_catchability_*} functions,
    which define the total biomass a fleet is able to catch.
  }
  \item{E}{
    A \link{formula} defining total catch a fleet can harvest at the current time/area (totalfleet/numberfleet),
    or a scaling factor used to define the stock caught (linearfleet/effortfleet/quotafleet).
  }
  \item{catchability_fs}{
    Either a list of stock names to \link{formula} objects, with an optional unnamed
    default option, or a \link{formula} object (which is always used).
  }
  \item{quota_table}{
    A data.frame with 'biomass' and 'quota' columns,
    'biomass' a numeric column, an upper bound for total biomass amount, the final value always being \code{Inf}.
    'quota' being a list of \code{\link{formula}}s, defining the quota for each, e.g. with \code{\link{g3_parameterized}}.
  }
  \item{sum_stocks}{
    Either a list of \link{g3_stock} objects to sum when choosing a value from \var{quote_table},
    or \code{NULL}, in which case choose the quota based on the current prey.
  }
  \item{recalc_f}{
    A \link{formula} denoting when to recalculate the current quota. For example \code{~cur_step == 1}
    will ensure the quota is only recalculated at the beginning of the year.
  }
  \item{amount_f}{
    Equivalent to \var{E} passed to \link{g3a_predate_catchability_totalfleet}.
  }
  \item{overconsumption_f}{
    Overconsumption rule, a formula that should cap all values in \var{stock__consratio} to <= 95%.
  }
  \item{run_f}{
    \link{formula} specifying a condition for running this action, default always runs.
  }
  \item{run_at}{
    Integer order that actions will be run within model, see \code{\link{g3_action_order}}.
  }
}

\details{
  \code{g3a_predate_fleet} will, given a \code{\link{g3_fleet}} "predator" and \code{\link{g3_stock}} prey,
  add predation into a model. The behaviour is driven by 2 parameters:

  \describe{
    \item{\var{suitabilities}}{Defines a predator's preference within a prey stock, normally one of the suitability functions, e.g. \code{\link{g3_suitability_exponentiall50}} }
    \item{\var{catchability_f}}{Defines a predator's overall requirements, set with one of the catchability functions, e.g. \code{\link{g3a_predate_catchability_totalfleet}}  }
  }

  For the definition of each catchability function, see the values section below.

  \subsection{Details for custom actions}{
    The actions will define the following stock instance variables for each given \var{fleet_stock} and \var{prey_stock}:
    \describe{
      \item{\var{prey_stock__suit_fleet_stock}}{Suitability of (prey_stock) for (fleet_stock), in a prey array.
          i.e. the result of calculating the formula in \var{suitabilities} for the current state of the prey}
      \item{\var{prey_stock__predby_predstock}}{Biomass of (prey_stock) caught by (fleet_stock), in a prey array}
      \item{\var{fleet_stock__catch}}{Biomass of all prey caught by (fleet stock), in a fleet array}
      \item{\var{prey_stock__totalpredate}}{Biomass of total consumed (prey_stock), in a prey array}
      \item{\var{prey_stock__consratio}}{Ratio of prey_stock__totalpredate / (current biomass), capped by \var{overconsumption_f}}
    }

    A model can have any number of \code{g3a_predate_*} actions, so long as the
    calling arguments are different. For instance, \code{run_f = ~age == 5} and
    \code{run_f = ~age == 7}.
  }
}

\value{
  \subsection{g3a_predate_catchability_totalfleet}{
    A \link{formula} that defines a fleet's desired catch by total biomass (e.g. landings data):
    \deqn{ \frac{E N_{sl} W_{sl}}{\displaystyle \sum_{\it stocks} \sum_{\it lengths} N_{sl} W_{sl}} }
    \describe{
      \item{\eqn{E}}{\var{E} argument, biomass caught by fleet. Generally a \code{\link{g3_timeareadata}} table containing landings data, with year/step/area/weight columns}
      \item{\eqn{N}}{Number of stock in length cell}
      \item{\eqn{W}}{Mean weight of stock in length cell}
    }
  }

  \subsection{g3a_predate_catchability_numberfleet}{
    A \link{formula} that defines a fleet's desired catch by total number of stock landed (not the biomass):
    \deqn{ \frac{E N_{sl}}{\displaystyle \sum_{\it stocks} \sum_{\it lengths} N_{sl}} }
    \describe{
      \item{\eqn{E}}{\var{E} argument, numbers caught by fleet. Generally a \code{\link{g3_timeareadata}} table containing landings data, or a constant quota}
      \item{\eqn{N}}{Number of stock in length cell}
    }
  }

  \subsection{g3a_predate_catchability_linearfleet}{
    A \link{formula} object that defines a linear relationship between desired catch and available biomass:
    \deqn{ E \Delta t N_{sl} W_{sl} }
    \describe{
      \item{\eqn{E}}{\var{E} argument, scaling factor for the stock that is to be caught, per month}
      \item{\eqn{\Delta t}}{length of current timestep in months}
      \item{\eqn{N}}{Number of stock in length cell}
      \item{\eqn{W}}{Mean weight of stock in length cell}
    }
  }

  \subsection{g3a_predate_catchability_effortfleet}{
    This is a multi-species extension to linearfleet, allowing differently-parameterized catchability per-stock.
    Returns a \link{formula} object that defines:
    \deqn{ c_{s} E \Delta t N_{sl} W_{sl} }
    \describe{
      \item{\eqn{c_{s}}}{\var{catchability_fs} argument for the current stock}
      \item{\eqn{E}}{\var{E} argument, scaling factor for the stock that is to be caught, per month}
      \item{\eqn{\Delta t}}{length of current timestep in months}
      \item{\eqn{N}}{Number of stock in length cell}
      \item{\eqn{W}}{Mean weight of stock in length cell}
    }
  }

  \subsection{g3a_predate_catchability_quotafleet}{
    A \link{formula} onject that defines catch based on the available biomass of the stock multiplied by a scaling factor set according to a simple harvest control rule:
    \deqn{ q E \Delta t N_{sl} W_{sl} }
    \describe{
      \item{\eqn{q}}{
        quota selected from \var{quota_table}, corresponding to the total biomass of \var{sum_stocks}.
        For example, given \code{data.frame(biomass = c(10000, Inf), quota = I(list(g3_parameterized('quota.low'), g3_parameterized('quota.high'))))},
        'quota.low' will be chosen when total biomass is less than 10000, otherwise 'quota.high' will be used.
        }
      \item{\eqn{E}}{\var{E} argument, scaling factor for the stock that is to be caught, per month}
      \item{\eqn{\Delta t}}{length of current timestep}
      \item{\eqn{N}}{Number of stock in length cell}
      \item{\eqn{W}}{Mean weight of stock in length cell}
    }
    ...if \var{recalc_f} is set, this will only be recaculated when true. Any other step
    will use the previous value.
  }

  \subsection{g3a_predate_fleet}{An action (i.e. list of formula objects) that will...\enumerate{
    \item{Zero fleet and prey catch counters}
    \item{For each prey, collect maximum desired by fleet for all prey, into a \var{prey_stock__predby_predstock} variable}
    \item{After all fleet consumption is done, scale consumption using \var{catchability_f}, sum into \var{prey_stock__totalpredate}}
    \item{After all consumption is done, temporarily convert \var{prey_stock__predby_predstock} to a proprotion of \var{prey_stock__totalpredate}}
    \item{Calculate \var{prey_stock__consratio} (ratio of consumed to available), capping using \var{overconsumption_f}. Update \var{prey_stock__num}}
    \item{Recalculate \var{prey_stock__predby_predstock}, \var{fleet_stock__catch}, post-overconsumption}
  }}
}

\seealso{
  \url{https://gadget-framework.github.io/gadget2/userguide/chap-stock.html#sec:stockpredator},
  \code{\link{g3_stock}}
}

\examples{
\dontshow{library(magrittr)}
areas <- c(a = 1, b = 2)
ling_imm <- g3_stock(c(species = 'ling', 'imm'), seq(20, 156, 4)) \%>\% g3s_age(3, 10)
ling_mat <- g3_stock(c(species = 'ling', 'mat'), seq(20, 156, 4)) \%>\% g3s_age(5, 15)
lln <- g3_fleet('lln') \%>\% g3s_livesonareas(areas[c('a', 'b')])

# Invent a lln_landings table
lln_landings <- expand.grid(
    year = 1999:2000,
    step = c(1, 2),
    area = areas[c('a', 'b')])
lln_landings$total_weight <- floor(runif(nrow(lln_landings), min=100, max=999))

# g3a_predate_catchability_totalfleet(): Set catch accordings to landings data
predate_action <- g3a_predate_fleet(
    lln,
    list(ling_imm, ling_mat),
    suitabilities = g3_suitability_exponentiall50(by_stock = 'species'),
    catchability_f = g3a_predate_catchability_totalfleet(
        g3_timeareadata('lln_landings', lln_landings, "total_weight") ))

# g3a_predate_catchability_numberfleet(): Fixed quota of 1000 fish
predate_action <- g3a_predate_fleet(
    lln,
    list(ling_imm, ling_mat),
    suitabilities = g3_suitability_exponentiall50(by_stock = 'species'),
    catchability_f = g3a_predate_catchability_numberfleet(
        g3_parameterized(
            'quota',
            value = 1000,
            by_predator = TRUE,
            scale = 0.5,
            optimise = FALSE) ))
attr(suppressWarnings(g3_to_r(list(predate_action))), 'parameter_template')
}
