## ----eval=TRUE, echo=FALSE, message=FALSE, warning=FALSE----------------------
# load packages now to avoid messages later
library(galaxias)
library(lubridate)
library(dplyr)

## -----------------------------------------------------------------------------
#  devtools::load_all()

## -----------------------------------------------------------------------------
library(galaxias)
library(tibble)

my_data <- tibble(
  latitude = c(-35.310, -35.273),
  longitude = c(149.125, 149.133),
  date = c("14-01-2023", "15-01-2023"),
  time = c("10:23", "11:25"),
  species = c("Callocephalon fimbriatum", "Eolophus roseicapilla"),
  location_id = c("ARD001", "ARD001")
  )

## -----------------------------------------------------------------------------
my_data

## -----------------------------------------------------------------------------
my_data |> suggest_workflow()

## -----------------------------------------------------------------------------
#  # I think we can get rid of this chunk?
#  library(lubridate)
#  
#  my_data_dwc <- df |>
#    # basic requirements of Darwin Core
#    set_occurrences(occurrenceID = composite_id(location_id,
#                                                sequential_id()),
#                    basisOfRecord = "humanObservation") |>
#    # place and time
#    set_coordinates(decimalLatitude = latitude,
#                    decimalLongitude = longitude) |>
#    set_locality(country = "Australia",
#                 locality = "Canberra") |>
#    set_datetime(eventDate = lubridate::dmy(date),
#                 eventTime = lubridate::hm(time)) |>
#    # taxonomy
#    set_scientific_name(scientificName = species,
#                        taxonRank = "species") |>
#    set_taxonomy(kingdom = "Animalia",
#                 phylum = "Aves")
#  
#  my_data_dwc |> print(n = 5)

## -----------------------------------------------------------------------------
library(lubridate)

my_data_dwc <- my_data |>
  # basic requirements of Darwin Core
  set_occurrences(occurrenceID = sequential_id(),
                  basisOfRecord = "humanObservation") |> 
  # place and time
  set_coordinates(decimalLatitude = latitude, 
                  decimalLongitude = longitude) |>
  set_locality(country = "Australia", 
               locality = "Canberra") |>
  set_datetime(eventDate = lubridate::dmy(date),
               eventTime = lubridate::hm(time)) |>
  # taxonomy
  set_scientific_name(scientificName = species, 
                      taxonRank = "species") |>
  set_taxonomy(kingdom = "Animalia",
               family = "Cacatuidae") 

my_data_dwc 

## -----------------------------------------------------------------------------
library(dplyr)

my_data_dwc_occ <- my_data_dwc |>
  select(any_of(occurrence_terms()))

my_data_dwc_occ

## -----------------------------------------------------------------------------
#  use_data(my_data_dwc_occ)

## ----eval=FALSE---------------------------------------------------------------
#  use_metadata_template()

## ----echo=FALSE, eval=FALSE---------------------------------------------------
#  # this code doesn't work any more
#  # best practice here might be to call `use_metadata()` then `readLines()` and `cat()`
#  library(delma)
#  metadata_string <- as_eml_chr(metadata_example)[3:15]
#    metadata_string |>
#    paste0("\n") |>
#    cat()

## ----eval=FALSE---------------------------------------------------------------
#  use_metadata("metadata.Rmd")

## ----eval=FALSE---------------------------------------------------------------
#  build_archive()

## -----------------------------------------------------------------------------
#  check_directory()

## -----------------------------------------------------------------------------
#  # Check against GBIF API
#  check_archive("dwc-archive.zip",
#                email = "your-email",
#                username = "your-username",
#                password = "your-password")

## -----------------------------------------------------------------------------
#  submit_archive()

